// Global context
// ==============
var csInterface = new CSInterface();
var isExportingCoverImage = false;
var fCoverImageOption;
var fCoverPage;
var fCoverExternalImagePath;
var lastExportedPage = 0;
var fRepublishDocDisplayCursor = 0;
var timer;
var resourceBundle;

var publicShareCheckCompleted = false;
var waitingToPublish = false;
var showPublishWarning = false;
var showInsertHTMLWarning = false;
const MAX_COOKIE_TEXT_WORD_LENGTH = 100;
let pubNewDocGAParamas = {measurementId : "",
                          enableCookieConsentBannerOption : "",
                          cookieConsentBannerText : ""};

// ==============
function sendEvent(data) {
  var event = new CSEvent("com.adobe.events.HTMLPublishExportDialog.html", "APPLICATION");
  event.extensionId = csInterface.getExtensionID();
  event.data = data;
  csInterface.dispatchEvent(event);
}

function logHighbeamEvent(cat, subcat, evt) {
  var usageEvent = {
    category: cat,
    subCategory: subcat,
    event: evt
  };
  var evtData = {
    type: "LogHighbeamEvent",
    usageEvent: usageEvent
  };
  sendEvent(evtData);
}

function logStateToFunnel(state) {
  var evtData = {};
  evtData.type = "Add State to Funnel";
  evtData.state = state;
  sendEvent(evtData);
}

var analyticsConstants = {
  IDUsageTracking_kLastMilePublishing: "LMP",

  IDUsageTracking_kRepublishEvt_noDocFound: "No_doc_found",
  IDUsageTracking_kRepublishEvt_exactMatch: "exact_match",
  IDUsageTracking_kRepublishEvt_origIdMatch: "orig_id_match",
  IDUsageTracking_kRepublishEvt_noMatch: "no_match",
  IDUsageTracking_kRepublishEvt_errorDocFetch: "error_docfetch",
  IDUsageTracking_kRepublishEvt_statusInProgress: "status_in_progress",
  IDUsageTracking_kRepublishEvt_exactMatchUnrelatedLink: "exactmatch_unrelatedlink",
  IDUsageTracking_kRepublishEvt_origMatchUnrelatedLink: "origmatch_unrelatedlink",
  IDUsageTracking_kRepublishEvt_noMatchExistingLink: "no_match_existinglink",
  IDUsageTracking_kRepublishEvt_exactMatchPrevversion: "exact_match_prevversion",
  IDUsageTracking_kRepublishEvt_origIdmatchPrevVersion: "orig_id_match_prevversion",
  IDUsageTracking_kRepublishEvt_exportSuccess: "exportsuccess",
  IDUsageTracking_kRepublishEvt_exportCancel: "exportcancel",
  IDUsageTracking_kRepublishEvt_exportWarning: "exportwarning",
  IDUsageTracking_kRepublishEvt_exportWarningCancel: "exportwarning_cancel",
  IDUsageTracking_kRepublishEvt_exportWarningOk: "exportwarning_ok",
  IDUsageTracking_kRepublishEvt_uploadStarted: "uploadstarted",
  IDUsageTracking_kRepublishEvt_uploadCancel: "uploadcancel",
  IDUsageTracking_kRepublishEvt_titleChange: "Titlechange",
  IDUsageTracking_kRepublishEvt_descriptionChange: "Descriptionchange",
  IDUsageTracking_kRepublishEvt_pagesChange: "Pageschange",
  IDUsageTracking_kRepublishEvt_exportAsChange: "ExportAsChange",
  IDUsageTracking_kRepublishEvt_advancedChange: "AddvancedChange",
  IDUsageTracking_kRepublishEvt_downloadChange: "DownloadChange",

  IDUsageTracking_kRepublishSubcat_cancel: "Republish_cancel",
  IDUsageTracking_kRepublishSubcat_documentScroll: "Republish_documentscroll",
  IDUsageTracking_kRepublishSubcat_try: "Republish_try",
  IDUsageTracking_kRepublishSubcat_fetchTime: "Republish_fetch_time",
  IDUsageTracking_kRepublishSubcat_ok: "Republish_ok",
  IDUsageTracking_kRepublishSubcat_confirmed: "Republish_confirmed",
  IDUsageTracking_kRepublishSubcat_notConfirmed: "Republish_Notconfirmed",
  IDUsageTracking_kRepublishSubcat_confirmedSettings: "Republish_confirmed_settings",

  IDUsageTracking_kPublishSubcat_shareEmbedControls: "ShareAndEmbedControls",
  IDUsageTracking_kPublishEvt_DisableHideShare: "ShareAndEmbedDisabled",
  IDUsageTracking_kPublishEvt_DisableHideSharePublish: "PublishWithShareAndEmbedDisabled"
};

function RepublishAnalyticsHelper() {
  var countExactMatch = 0,
    countOrigMatch = 0,
    countNoMatch = 0,
    exactMatchIndex = null,
    origMatchIndex = null,
    noMatchIndex = null,
    selectedIndex = null,
    scrollState = null,
    pdfSelectionChanged = false,
    pageOptionsSelectionChanged = false,
    isPageRangeSelected = null,
    spreadControlSelectionChanged = false,
    disableShareOptionChangedOnce = false;

  this.pageRangeInitialText = null;

  this.setMatchingCounts = function (matchCount) {
    if (matchCount.exactMatch === undefined || matchCount.origMatch === undefined || matchCount.noMatch === undefined) {
      throw Error("Match count information not passed correctly");
    }
    countExactMatch = matchCount.exactMatch;
    countOrigMatch = matchCount.origMatch;
    countNoMatch = matchCount.noMatch;
    if (countExactMatch > 0) {
      exactMatchIndex = 1;
    }
    if (countOrigMatch > 0) {
      origMatchIndex = 1 + countExactMatch;
    }
    if (countNoMatch > 0) {
      noMatchIndex = 1 + countExactMatch + countOrigMatch;
    }
  };

  this.setSelectedIndex = function (index, notify) {
    selectedIndex = index;

    if (notify) {
      selectionChanged();
    }
  };

  this.getMatchState = function () {
    if (countExactMatch > 0)
      return RepublishAnalyticsHelper.DocMatchState["kExactMatchFound"];
    if (countOrigMatch > 0)
      return RepublishAnalyticsHelper.DocMatchState["kNotExactButOrigMatchFound"];
    return RepublishAnalyticsHelper.DocMatchState["kNoMatchFound"];
  };

  this.getMatchingStateObject = function () {
    var scopeVar = $('body').scope();
    return {
      countExactMatch: countExactMatch,
      countOrigMatch: countOrigMatch,
      countNoMatch: countNoMatch,
      exactMatchIndex: exactMatchIndex !== null ? exactMatchIndex : -1,
      origMatchIndex: origMatchIndex !== null ? origMatchIndex : -1,
      noMatchIndex: noMatchIndex !== null ? noMatchIndex : -1,
      selectedIndex: selectedIndex !== null ? selectedIndex : -1,
      isRepublishing: scopeVar.prefs.isRepublishing === "1"
    };
  };

  this.logRepublishDocumentType = function (subcat) {
    if (countExactMatch !== 0) {
      if (selectedIndex >= exactMatchIndex && selectedIndex < exactMatchIndex + countExactMatch) {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat, analyticsConstants.IDUsageTracking_kRepublishEvt_exactMatch);
        if (selectedIndex > exactMatchIndex) {
          logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat,
            analyticsConstants.IDUsageTracking_kRepublishEvt_exactMatchPrevversion);
        }
      } else {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat,
          analyticsConstants.IDUsageTracking_kRepublishEvt_exactMatchUnrelatedLink);
      }
    }
    if (countOrigMatch !== 0) {
      if (selectedIndex >= origMatchIndex && selectedIndex < origMatchIndex + countOrigMatch) {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat, analyticsConstants.IDUsageTracking_kRepublishEvt_origIdMatch);
        if (selectedIndex > origMatchIndex) {
          logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat,
            analyticsConstants.IDUsageTracking_kRepublishEvt_origIdmatchPrevVersion);
        }
      } else if (selectedIndex >= origMatchIndex + countOrigMatch) {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat,
          analyticsConstants.IDUsageTracking_kRepublishEvt_origMatchUnrelatedLink);
      }
    }
    if (noMatchIndex !== null && selectedIndex >= noMatchIndex) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, subcat,
        analyticsConstants.IDUsageTracking_kRepublishEvt_noMatchExistingLink);
    }
  };

  var self = this;

  function selectionChanged() {
    if (scrollState === null) {
      scrollState = "initialized";

      if (self.getMatchState() === RepublishAnalyticsHelper.DocMatchState.kExactMatchFound) {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_documentScroll,
          analyticsConstants.IDUsageTracking_kRepublishEvt_exactMatch);
      }
      else if (self.getMatchState() === RepublishAnalyticsHelper.DocMatchState.kNotExactButOrigMatchFound) {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_documentScroll,
          analyticsConstants.IDUsageTracking_kRepublishEvt_origIdMatch);
      }
      else {
        logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_documentScroll,
          analyticsConstants.IDUsageTracking_kRepublishEvt_noMatch);
      }
    }
  };

  this.togglePdfSelectionChanged = function () {
    pdfSelectionChanged = !pdfSelectionChanged;
  };

  this.togglePageOptionsSelection = function () {
    pageOptionsSelectionChanged = !pageOptionsSelectionChanged;
  };

  this.toggleSpreadControlSelection = function () {
    spreadControlSelectionChanged = !spreadControlSelectionChanged;
  };

  this.setPageRangeSelected = function (what) {
    isPageRangeSelected = what;
  };

  this.logRepublishConfirmedSettings = function () {
    if (pdfSelectionChanged) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmedSettings,
        analyticsConstants.IDUsageTracking_kRepublishEvt_downloadChange);
    }
    var scopeVar = $('body').scope();
    var currentPageRangeText = scopeVar.prefs.pageRange;
    if (pageOptionsSelectionChanged || isPageRangeSelected && this.pageRangeInitialText !== currentPageRangeText) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmedSettings,
        analyticsConstants.IDUsageTracking_kRepublishEvt_pagesChange);
    }
    if (spreadControlSelectionChanged) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmedSettings,
        analyticsConstants.IDUsageTracking_kRepublishEvt_exportAsChange);
    }

    if (scopeVar.prefs.repub.title !== scopeVar.prefs.republishUserPub.documentName) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmedSettings,
        analyticsConstants.IDUsageTracking_kRepublishEvt_titleChange);
    }

    if (scopeVar.prefs.repub.description !== scopeVar.prefs.republishUserPub.description) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmedSettings,
        analyticsConstants.IDUsageTracking_kRepublishEvt_descriptionChange);
    }
  };

  this.disableShareOptionOnce = function () {
    if (!disableShareOptionChangedOnce) {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kPublishSubcat_shareEmbedControls,
        analyticsConstants.IDUsageTracking_kPublishEvt_DisableHideShare);
      disableShareOptionChangedOnce = true;
    }
  };

  this.logIfShareIsDisabled = function (scopeVar) {
    if (scopeVar.prefs.disableShareOption === "1") {
      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kPublishSubcat_shareEmbedControls,
        analyticsConstants.IDUsageTracking_kPublishEvt_DisableHideSharePublish);
    }
  };
}

RepublishAnalyticsHelper.DocMatchState = Object.freeze({
  kExactMatchFound: 0,
  kNotExactButOrigMatchFound: 1,
  kNoMatchFound: 2
});

var analyticsHelper = new RepublishAnalyticsHelper();

function getDialogSettings() {
  var dialogSettings = JSON.parse(JSON.stringify($('body').scope().prefs));
  dialogSettings.pdfPresetList = "";
  if (dialogSettings.isRepublishing == '1' && dialogSettings.isRepublishDocSelected == '1') {
    dialogSettings.isRepublishing = '1';
    //pick title and description from republish tab
    dialogSettings.title = dialogSettings.repub.title;
    dialogSettings.description = dialogSettings.repub.description;
  }
  else {
    dialogSettings.isRepublishing = '0';
  }
  return dialogSettings;
}

var apiConfigData = {
  accessToken: "",
  idlmpHostName: "",
  cpHostName: "",
  cpApiKey: "",

  get cpPublicPublishPolicy() {
    return "/api/v2/lastmile/users/me/policy";
  },

  get userPubsApiPath() {
    return "/api/v1/idpubs/allUserPublications";
  }
};

// This will contain all the pubs fetched from CP
// format of pub:
/*{
    "documentURL": "/view/<asset-id>",
    "asset_id": "<asset-id>",
    "coverPreview": "https://<url-path>/rendition/{format}/{dimension}/{size}",
    "createdTime": <in millis>,
    "updatedTime": <in millis>,
    "documentName": "<title>",
    "description": "<description>",
    "resource_path": "<resource-path>"
}*/

var userPubs = {};
var FETCH_STATE = {
  INITIAL: 0,
  IN_PROGRSS: 1,
  COMPLETED: 2,
  ERROR: 3
};
Object.freeze(FETCH_STATE);

(function initializeuserPubs() {
  userPubs.pubs = [];
  userPubs.documentId = "";
  userPubs.origDocumentId = "";
  userPubs.RETRY_INTERVAL = 1000;
  userPubs.retryAttempts = 0;
  userPubs.MAX_ATTEMPTS = 3;

  var fetchBeginTime = null;
  var timeToFetch = null;
  userPubs.fetchBegin = function () {
    fetchBeginTime = new Date().getTime();
  };
  userPubs.fetchComplete = function () {
    timeToFetch = (new Date().getTime() - fetchBeginTime) / 1000.0;
  };
  userPubs.getTimeToFetch = function () {
    return timeToFetch;
  };

  userPubs.fetchState = FETCH_STATE.INITIAL;

})();

var coverImage = "";

function onPublish() {
  if (!publicShareCheckCompleted) {
    // Wait till check is completed
    $("#publishBtn").prop('disabled', true);
    waitingToPublish = true;
    return; // We shall resume when check is complete.
  }

  var publishButtonEvt = {};
  publishButtonEvt.type = "Publish Ok Button Clicked";
  publishButtonEvt.dialogSettings = getDialogSettings();
  publishButtonEvt.matchState = analyticsHelper.getMatchingStateObject();
  var scopeVar = $('body').scope();
  if (scopeVar.prefs.isRepublishing === "1") {
    logStateToFunnel("RePubOk");
    analyticsHelper.logRepublishDocumentType(analyticsConstants.IDUsageTracking_kRepublishSubcat_ok);
    var warningModal = document.querySelector('#republishConfirmModal');
    warningModal.data = publishButtonEvt;
    warningModal.on('click', '#republishOkButton', function () {
      //log republish confirmed event
      analyticsHelper.logRepublishDocumentType(analyticsConstants.IDUsageTracking_kRepublishSubcat_confirmed);
      analyticsHelper.logRepublishConfirmedSettings();
      analyticsHelper.logIfShareIsDisabled(scopeVar);
      sendEvent($('#republishConfirmModal')[0].data);
    });
    warningModal.on('click', '#republishCancelButton', function () {
      //log cancel event
      analyticsHelper.logRepublishDocumentType(analyticsConstants.IDUsageTracking_kRepublishSubcat_notConfirmed)
    });
    warningModal.show();
  }
  else {
    logStateToFunnel("PubOk");
    analyticsHelper.logIfShareIsDisabled(scopeVar);
    sendEvent(publishButtonEvt);
  }
}

function onCancel() {
  var cancelButtonEvt = {};
  cancelButtonEvt.type = "Publish Cancel Button Clicked";
  var scopeVar = $('body').scope();
  if (scopeVar.prefs.isRepublishing) {
    analyticsHelper.logRepublishDocumentType(analyticsConstants.IDUsageTracking_kRepublishSubcat_cancel);
  }
  csInterface.closeExtension();
}

function openExternalImageFileOpenDialog() {
  var fileOpenButtonEvt = {};
  fileOpenButtonEvt.type = "Cover Thumbnail Choose Image Button Clicked";
  fileOpenButtonEvt.imagePath = $('body').scope().prefs.coverImagePath;
  sendEvent(fileOpenButtonEvt);
}

function onCoverPageChanged(pageIndex) {
  var coverPageChoiceChangedEvt = {};

  coverPageChoiceChangedEvt.type = "Cover Thumbnail Page Changed";
  coverPageChoiceChangedEvt.index = pageIndex;
  sendEvent(coverPageChoiceChangedEvt);
}

function sendCoverImageOptionChangeEvt() {
  isExportingCoverImage = true;
  lastExportedPage = 0;
  var dialogSettings = getDialogSettings();
  var coverImageOptionChangeEvt = {};
  coverImageOptionChangeEvt.type = "Cover Image Option Changed";
  fCoverImageOption = coverImageOptionChangeEvt.coverImageOption = dialogSettings.coverImageOption;
  fCoverPage = coverImageOptionChangeEvt.coverPage = dialogSettings.coverPage;
  fCoverExternalImagePath = coverImageOptionChangeEvt.coverExternalImagePath = dialogSettings.coverImagePath;
  sendEvent(coverImageOptionChangeEvt);
}

function onCoverImageOptionChange() {
  if (!isExportingCoverImage)
    sendCoverImageOptionChangeEvt();
}

function isCoverImageExportRequired() {
  var dialogSettings = getDialogSettings();
  if (!(fCoverImageOption == dialogSettings.coverImageOption && fCoverPage == dialogSettings.coverPage && fCoverExternalImagePath == dialogSettings.coverImagePath)) {
    onCoverImageOptionChange();
    return true;
  }
  else
    return false;
}

function doFirstPageExportAsCoverImage() {
  var dialogSettings = getDialogSettings();
  //if the first page option is already selected, don't proceed further as export failure for first page has come
  //also handling the case where again first page export fails and option is not first page
  //TODO : maybe we could show the default image in this case
  if (dialogSettings.coverImageOption === "1" || lastExportedPage === 1)
    return;
  else {
    lastExportedPage = 1;
    var coverImageOptionChangeEvt = {};
    coverImageOptionChangeEvt.type = "Cover Image Option Changed";
    coverImageOptionChangeEvt.coverImageOption = "1"; //first page
    coverImageOptionChangeEvt.coverPage = "";
    coverImageOptionChangeEvt.coverExternalImagePath = "";
    sendEvent(coverImageOptionChangeEvt);
  }
}


function loadJSX() {
  var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
  csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
  new CSInterface().evalScript(script, callback);
}

function sendExtenionLoadedEvent() {
  var extLoadedEvt = {};
  extLoadedEvt.type = "Extension Loaded";
  sendEvent(extLoadedEvt);
}

// For locales like ru_RU etc. wherein words are large comparatively,
// Dialog needs some adjustent to accomodate text and controls.
function updateForSpecificLocale(locale) {
  // For cs_CZ and uk_UA locale GA descriptiion is getting divided into multipline
  // sentence due to presence of <br>. Removing br makes it correct.
  if (locale === "cs_CZ" || locale === "uk_UA") {
    $("#GoogleAnalyticsDesc").html(resourceBundle['AboutGoogleAnalytics'].replace("<br>", " "));
  }
  // Error for wrong measurement ID is shown next to input text. Move it to next line to avoid clipping.
  if (locale === "uk_UA" || locale === "ru_RU") {
    $("#InvalidMeasurementId").insertAfter($(".measurementId"));
    // Remove spaces between controls.
    $("#InvalidMeasurementId").css("width", "100%");
    $("#InvalidMeasurementId").css("margin-left", "0%");
    $(".measurementId").css("margin-bottom", "0%");
    $(".cookieBanner").css("margin-top", "0%");
  }
}

function onLoaded() {
  var appName = csInterface.hostEnvironment.appName;
  var language = csInterface.hostEnvironment.appUILocale;
  loadJSX();
  $("coral-radio").each(function () {
    var stringToLocalise = $(this).attr("data-label");
    $(this).find("coral-radio-label").attr("data-locale", stringToLocalise);
  });

  $("coral-checkbox").each(function () {
    var stringToLocalise = $(this).attr("data-label");
    $(this).find("coral-checkbox-label").attr("data-locale", stringToLocalise);
  });

  // Update the icon
  var scaleSuffix = "";
  if (csInterface.getScaleFactor() > 1.9) {
    scaleSuffix = "_at2x";
  }
  $(this).find('#republishConfirmModal img').attr("src", "./resources/icons/id_cc_appicon_48" + scaleSuffix + ".png");

  resourceBundle = csInterface.initResourceBundle();
  updateForSpecificLocale(language);
  csInterface.addEventListener("com.adobe.events.PublishHTMLExportDialog.indesign", poExportDialogEvtHandler);
  sendExtenionLoadedEvent();

  // Disable drag and drop inside the dialog
  window.ondragenter = function (event) {
    event.dataTransfer.dropEffect = 'none';
    event.stopPropagation();
    event.preventDefault();
  };
  window.ondragover = function (event) {
    event.dataTransfer.dropEffect = 'none';
    event.stopPropagation();
    event.preventDefault();
  };
  window.ondrop = function (event) {
    event.dataTransfer.dropEffect = 'none';
    event.stopPropagation();
    event.preventDefault();
  };
  window.oncontextmenu = function (event) {
    if (!$(event.target).is('input:text') && !$(event.target).is('textarea')) {
      event.stopPropagation();
      event.preventDefault();
    }
  };
}

function isValidTitle(text) {
  var blockedChars = ['<', '>', '(', ')', '-', '"', "'", ':', '&', ';', '/', '%', '{', '}', '*', '%', '#'];
  for (var i=0;i<text.length;i++) {
    if (blockedChars.indexOf(text[i]) > -1) {
      return false;
    }
  }
  return true;
}

function showWarningMessage(msg) {
  var warningModal = document.querySelector('#warningModal');
  $("#warningMessage").text(msg);
  warningModal.show();
}

function showWarningMessageForPublicShare(forError) {
  var warningModal = document.querySelector('#publishDisabledDialog');
  if (forError) {
    $("#publishDisabledHeader").hide();
    $("#publishDisabled").hide();
    $("#publishUnknownError").show();
  }
  else {
    $("#publishUnknownError").hide();
    $("#publishDisabledHeader").show();
    $("#publishDisabled").show();
  }
  $('#publishDisabledDialog a').click(function (evt) {
    window.cep.util.openURLInDefaultBrowser(resourceBundle.CPPublicSharingLearnMore);
  });
  $('#publishDisabledDialog button').click(function (evt) {
    csInterface.closeExtension();
  });
  warningModal.show();
}

function createToolTip(target, message, toolTipClass) {
  //remove prev tooltip
  $('.' + toolTipClass).remove();
  if (!isEllipsisActive($(target), message)) {
    return;
  }
  var tooltip = new Coral.Tooltip().set({
    content: {
      innerHTML: message
    },
    //variant: 'success',
    target: target,
    placement: 'bottom',
    delay: 50,
    // Don't show or hide automatically
    interaction: 'on'
  });
  $(tooltip).addClass(toolTipClass + " tooltip");
  /*$(tooltip).blur(function(){
    $(this).hide();
  });*/
  document.body.appendChild(tooltip);
}

function isEllipsisActive(el, msg) {
  return_val = false;
  var tmpElId = "tmp" + (Math.floor(Math.random() * 10000));
  var html = "<span id='" + tmpElId + "' style='position: fixed; top: -9999px; visibility: hidden;   padding: .625rem; font-size: 14px;'>" + msg + "</span>";
  $("body").append(html);

  if (el.width() < $('#' + tmpElId).width()) {
    return_val = true;
  }
  $('#' + tmpElId).remove();
  return return_val;
}

function poExportDialogEvtHandler(event) {
  var evtInfo = event.data;
  var scopeVar = $('body').scope();
  if (evtInfo) {
    if (evtInfo.type === "Export Dialog UI Initialization") {
      var prefData = evtInfo.prefData;
      scopeVar.initScope(prefData);

      var configData = evtInfo.configData;
      apiConfigData.accessToken = configData["accessToken"];
      apiConfigData.idlmpHostName = configData["idlmpHostName"];
      apiConfigData.cpHostName = configData["cpHostName"];
      apiConfigData.cpApiKey = configData["cpApiKey"];

      userPubs.documentId = configData["documentId"];
      userPubs.origDocumentId = configData["origDocumentId"];
      if (configData["debug"]) {
        $('#debug_message').css("display", "block");
      }

      CheckAsyncForPublicShareFlagInCommunityPlatform();

      addListToSelect(configData.pageList, $('#pageNum').get(0), prefData.coverPage);


      $("#learnMore").click(function () {
        window.cep.util.openURLInDefaultBrowser(configData.LearnMoreURL);
      });

      $("#securityUpdateLearnMoreIAM").click(function () {
        window.cep.util.openURLInDefaultBrowser(configData.SecurityUpdateLearnMoreURL);
      });

      $("#securityUpdateLearnMoreIH").click(function () {
        window.cep.util.openURLInDefaultBrowser(configData.SecurityUpdateLearnMoreURL);
      });

      $("#LearnMoreInvalidMeasurementId").click(function () {
        window.cep.util.openURLInDefaultBrowser(resourceBundle.LearnMoreAboutGoogleAnalyticsLink);
      });

      $("#LearnMoreGoogleAnalytics").click(function () {
        window.cep.util.openURLInDefaultBrowser(resourceBundle.LearnMoreAboutGoogleAnalyticsLink);
      });

      if (!prefData.coverPage) {
        $('#pageNum option')[0].selected = true;
        $('#pageNum').trigger("change");
      }

      $('.btnStepper').click(function (event) {
        var isUp = false;
        if (this.id === "pageNumUp") {
          isUp = true;
        }
        var upperLimit = $('#pageNum option').size();
        var idx = $("#pageNum option:selected").index();
        if (isUp) { // increment selected index
          if (idx < upperLimit) {
            $('#pageNum coral-select-item')[idx + 1].selected = true;
            $('#pageNum').trigger("change");
          }
        }
        else { // Decrement index
          if (idx > 0) {
            $('#pageNum coral-select-item')[idx - 1].selected = true;
            $('#pageNum').trigger("change");
          }
        }
      })

    }
    else if (evtInfo.type === "Update External Image Path") {
      var coverPath = evtInfo.coverImagePath;
      scopeVar.setCoverPath(coverPath);
      var toolTipParentEl = $("input#externalImagePath")[0];
      createToolTip(toolTipParentEl, coverPath, "tooltip-image-path");
    }
    else if (evtInfo.type === "Cover Image Exported") {
      isExportingCoverImage = false;
      var exportedCoverPath = evtInfo.exportedCoverImagePath;
      if (!isCoverImageExportRequired())
        $('#coverImagePlaceholder').attr('src', exportedCoverPath);
    }
    else if (evtInfo.type === "Cover Image Export Failure") {
      isExportingCoverImage = false;
      if (!isCoverImageExportRequired())
        doFirstPageExportAsCoverImage();
    }
    else if (evtInfo.type === "Invalid Preferences") {
      var pageRangeError = evtInfo.pageRangeStatus;
      if (pageRangeError) {
        if (pageRangeError !== "Valid")
          showWarningMessage(pageRangeError);
      }

      var pageNumError = evtInfo.pageNumberStatus;
      if (pageNumError) {
        if (pageNumError !== "Valid")
          showWarningMessage(pageNumError);
      }
    }
    else if (evtInfo.type === "Page Number Validation Results") {
      if (evtInfo.pageNumberStatus === "Valid") {
        scopeVar.prefs.originalCoverPage = scopeVar.prefs.coverPage;
      } else {
        var pageNumError = evtInfo.pageNumberStatus;
        if (pageNumError) {
          scopeVar.$apply(function () {
            scopeVar.prefs.coverPage = scopeVar.prefs.originalCoverPage;
          });
          showWarningMessage(pageNumError);
        }
      }
    }
    else if (evtInfo.type === "Page Range Validation Results") {
      if (evtInfo.pageRangeStatus === "Valid") {
        scopeVar.prefs.originalPageRange = scopeVar.prefs.pageRange;
      } else {
        var pageRangeError = evtInfo.pageRangeStatus;
        if (pageRangeError) {
          showWarningMessage(pageRangeError);
        }
        scopeVar.$apply(function () {
          scopeVar.prefs.pageRange = scopeVar.prefs.originalPageRange;
        });
      }
    }
    else if (evtInfo.type === "Show Publish IAM Warning") {
      if (!showInsertHTMLWarning) {
        showPublishIAMUI(true);
      }
      //set showPublishWarning preference (IAM) to false, once IAM is shown or InsertHTML warning is shown
      var updateIAMStateEvt = {};
      updateIAMStateEvt.type = "Warning IAM State Changed";
      updateIAMStateEvt.showPublishWarning = false;
      sendEvent(updateIAMStateEvt);
    }
    else if (evtInfo.type === "Unload Extension") {
      csInterface.closeExtension();
    }
  }
}

function addListToSelect(list, selectElement, selectedItem) {
  if (list.length > 0) {
    var smallChunk = list.splice(0, 25);
    smallChunk.forEach(function (value, index) {
      addValueToSelect(value, selectElement);
      if (value == selectedItem)
        selectElement.lastChild.selected = true;
    });
    setTimeout(function () {
      addListToSelect(list, selectElement, selectedItem);
    }, 0);
  }
}

function addValueToSelect(value, selectElement, itemName) {
  if (itemName == undefined)
    itemName = value;
  var item = {};
  item.value = value;
  item.content = {};
  item.content.innerHTML = itemName;
  selectElement.items.add(item);
}

function getFormattedDateString(date) {
  var monthNames = [
    "January", "February", "March",
    "April", "May", "June", "July",
    "August", "September", "October",
    "November", "December"
  ];
  var day = date.getDate();
  var monthIndex = date.getMonth();
  var year = date.getFullYear();
  var hour = date.getHours();
  if (hour < 10)
    hour = '0' + hour;
  var minutes = date.getMinutes();
  if (minutes < 10)
    minutes = '0' + minutes;
  var hrsString = resourceBundle['hrs'];
  if (hrsString == undefined)
    hrsString = "";
  return (day + ' ' + monthNames[monthIndex] + ' ' + year + ' at ' + hour + ':' + minutes + ' ' + hrsString);
}

function showRepublishWidgets(show) {
  if (show === undefined || show == true) {
    $('.existingDocTitle').show();
    $('.existingDocPublishDate').show();
    $('#docSettings').show();
    $('#republishViewLink').show();
    $('#republishImagePlaceholder').show();
  } else {
    $('.existingDocTitle').hide();
    $('.existingDocPublishDate').hide();
    $('#docSettings').hide();
    $('#republishViewLink').hide();
    $('#republishImagePlaceholder').hide();
  }
}

function showPublishIAMUI(show) {
  if (show === undefined || show == true) {
    $('.about').hide();
    $('.insertHTMLWarning').hide();
    $('.iamWarning').show();
  } else {
    $('.iamWarning').hide();
    $('.insertHTMLWarning').hide();
    $('.about').show();

  }
}

function showInsertHTMLWarningUI(show) {
  if (show === undefined || show == true) {
    $('.about').hide();
    $('.iamWarning').hide();
    $('.insertHTMLWarning').show();
  } else {
    $('.iamWarning').hide();
    $('.insertHTMLWarning').hide();
    $('.about').show();
  }
}

function isValidMeasurementId(measurementId) {
  let pattern = /^[gG]-[a-zA-Z0-9]{1,10}$/;
  return (!measurementId || pattern.test(measurementId));
}

function onInvalidMeasurementId() {
  $("#InvalidMeasurementId").css('visibility', "visible");
  $("#InvalidMeasurementIdDesc").attr('data-locale', resourceBundle['InvalidMeasurementId']);
  $("#MeasurementIdInput")[0].style.borderColor = 'red';
  $("#MeasurementIdInput").css('box-shadow', 'none');
}

function onValidMeasurementId() {
  $("#InvalidMeasurementId").css('visibility', 'hidden');
  $("#MeasurementIdInput")[0].style.borderColor = '';
}

function changePublishButtonStatus() {
  // If document title is empty then disable the publish button
  const docTitle = $(".newDoc .title").val().trim();
  if (docTitle === "") {
    $("#publishBtn").prop('disabled', true);
    return;
  }

  const measurementIdText = $('#MeasurementIdInput').val();
  const enableCookieBanner = $("#EnableCookieConsentBannerOption")[0].checked;
  const cookieBannerText = $("#CookieConsentBannerText").val().trim();

  // Base case - If nothing has changed on analytics tab.
  if (measurementIdText === "" && !enableCookieBanner) {
    $("#publishBtn").prop('disabled', false);
    return;
  }

  if ((measurementIdText === "" && enableCookieBanner)
      || !isValidMeasurementId(measurementIdText)
      || (enableCookieBanner && (cookieBannerText === ""))) {
    $("#publishBtn").prop('disabled', true);
  } else {
    $("#publishBtn").prop('disabled', false);
  }
}

function getSelectedPublication () {
  var scopeVar = $('body').scope();
  if (scopeVar.prefs.isRepublishing === "1" && userPubs.fetchState === FETCH_STATE.COMPLETED) {
    for (let i = 0; i < userPubs.pubs.length; i++) {
      if (userPubs.pubs[i].asset_id === scopeVar.prefs.republishAssetID) {
        publication = userPubs.pubs[i];
        return publication;
      }
    }
  }
  return pubNewDocGAParamas;
}

function initGAAnalyticsControls () {
  let publication = getSelectedPublication();
  if (publication.measurementId == undefined || publication.measurementId === "") {
    $("#MeasurementIdInput").val("");
    $("#MeasurementIdInput").attr("placeholder", resourceBundle['MeasurementIdPlaceholder']);
  } else {
    $("#MeasurementIdInput").val(publication.measurementId);
  }

  if (publication.cookieConsentBannerText == undefined || publication.cookieConsentBannerText === "") {
    $("#CookieConsentBannerText").val("");
    $("#CookieConsentBannerText").attr("placeholder", resourceBundle['CookieBannerPlaceHolderText']);
  } else {
    $("#CookieConsentBannerText").val(publication.cookieConsentBannerText);
  }

  if (publication.enableCookieConsentBannerOption == "1") {
    $("#EnableCookieConsentBannerOption").prop('checked', true);
    $("#CookieConsentBannerText").prop('disabled', false);
    $("#CookieBannerTextAreaHeading").removeClass('disabledLabel');
  } else {
    $("#EnableCookieConsentBannerOption").prop('checked', false);
    $("#CookieConsentBannerText").prop('disabled', true);
    $("#CookieBannerTextAreaHeading").addClass('disabledLabel');
  }

  const measurementIdText = $("#MeasurementIdInput").val();
  if (((measurementIdText === "") && $("#EnableCookieConsentBannerOption")[0].checked) || !isValidMeasurementId(measurementIdText)) {
    onInvalidMeasurementId();
  } else {
    onValidMeasurementId();
  }
}

var bodyApp = angular.module('exportDialog', []);
bodyApp.controller('BodyCtrl', ['$scope', '$http', '$element', function ($scope, $http, $element) {


  function InitScope(prefData) {

    // remove tooltips on click
    $("body").on("click", function () {
      $('.tooltip').each(function (index) {
        $(this)[0].hide();
      });
    });

    //sanitize title field
    var isValid = isValidTitle(prefData.title);
    if (!isValid) {
      prefData.title = prefData.defaultTitle;
    }

    $scope.prefs = prefData;
    showPublishWarning = $scope.prefs.showPublishWarning;
    showInsertHTMLWarning = $scope.prefs.showInsertHTMLWarning;
    $scope.prefs.originalCoverPage = $scope.prefs.coverPage;
    $scope.prefs.originalPageRange = $scope.prefs.pageRange;
    $scope.prefs.enabledTab = "General";
    $scope.prefs.isRepublishing = '0';
    $scope.isRepublishDocSelected = '0';
    $scope.prefs.repub = {};
    analyticsHelper.setPageRangeSelected(prefData.pageRangeFormat);
    analyticsHelper.pageRangeInitialText = prefData.pageRange;
    $scope.prefs.measurementId = pubNewDocGAParamas.measurementId = prefData.measurementId;
    $scope.prefs.enableCookieConsentBannerOption = pubNewDocGAParamas.enableCookieConsentBannerOption = prefData.enableCookieConsentBannerOption;
    $scope.prefs.cookieConsentBannerText = pubNewDocGAParamas.cookieConsentBannerText = prefData.cookieConsentBannerText;

    if (showPublishWarning && !showInsertHTMLWarning) {
      showPublishIAMUI(true);
    }

    if (showPublishWarning) {
      //set showPublishWarning preference (IAM) to false, once IAM is shown or InsertHTML warning is shown
      var updateIAMStateEvt = {};
      updateIAMStateEvt.type = "Warning IAM State Changed";
      updateIAMStateEvt.showPublishWarning = false;
      sendEvent(updateIAMStateEvt);
    }

    var pageRangeSelectNewDoc = $('[name=pageRange]').get(0);
    var pageRangeSelectUpdateExisting = $('[name=pageRange]').get(2);
    prefData.pageRangeDDEntries.forEach(function (value, index) {
      addValueToSelect(value, pageRangeSelectNewDoc);
      addValueToSelect(value, pageRangeSelectUpdateExisting);
      if (value == prefData.pageRange)
        pageRangeSelectNewDoc.lastChild.selected = true;
      pageRangeSelectUpdateExisting.lastChild.selected = true;
    });

    $('.pageOptions').each(function () {
      if ($(this)[0].value === $scope.prefs.pageRangeFormat)
        $(this)[0].checked = true;
      else
        $(this)[0].checked = false;
    });

    $(".pageRangeInput").val(prefData.pageRange);
    $scope.$apply(function () {
      $scope.prefs.pageRange = prefData.pageRange;
    });

    var resolutionSelect = $('#resolution').get(0);
    prefData.imageResolutionOptions.forEach(function (item, index) {
      addValueToSelect(item.value, resolutionSelect, item.name);
      if (item.value == prefData.imageResolution)
        resolutionSelect.lastChild.selected = true;
    });

    var pdfPresetSelect = $('#pdfPreset').get(0);
    prefData.pdfPresetList.forEach(function (value, index) {
      addValueToSelect(value, pdfPresetSelect);
      if (value == prefData.selectedPdfPreset)
        pdfPresetSelect.lastChild.selected = true;
    });

    $('#format > coral-select-item').each(function (index) {
      if ($(this)[0].value == prefData.imageFormat)
        $(this)[0].selected = true;
    });

    $('#gifOptions > coral-select-item').each(function (index) {
      if ($(this)[0].value == prefData.gifPaletteType)
        $(this)[0].selected = true;
    });

    $('#jpegQuality > coral-select-item').each(function (index) {
      if ($(this)[0].value == prefData.jpegImageQuality)
        $(this)[0].selected = true;
    });

    $("[name=thumbnailOptions]").each(function (index) {
      if ($(this)[0].value == $scope.prefs.coverImageOption)
        $(this)[0].checked = true;
    });
    $('.spreadControl > button').each(function (index) {
      if ($(this)[0].value == prefData.spreadControl)
        $(this)[0].selected = true;
    });

    $scope.$apply();
    var republishDocListselect = $('#republishDocList').get(0);
    republishDocListselect.addEventListener('coral-select:showitems', function (event) {
      if (userPubs.fetchState != FETCH_STATE.COMPLETED || fRepublishDocDisplayCursor < userPubs.pubs.length)
        event.preventDefault(); // used to show the loading icon in list
    });

    if (showInsertHTMLWarning) {
      showInsertHTMLWarningUI(showInsertHTMLWarning);
    }

    fetchUserPublications();

    if (prefData.pdfCheckBoxOption == "1") {
      $(".pdfCheckBoxOption").each(function () {
        $(this)[0].checked = true;
      });
    }

    if (prefData.disableShareOption == "1") {
      $(".disableShareOption").each(function () {
        $(this)[0].checked = true;
      });
    }

    if (prefData.enableSearchTextOption == "1") {
      $(".enableSearchTextOption").each(function () {   
        $(this)[0].checked = true;
      });
    }

    if (prefData.enableSearchTextOption == "0") {
      $(".enableSearchTextOption").each(function () {   
        $(this)[0].checked = false;
      });
    }

    initGAAnalyticsControls();
    $("#InvalidMeasurementId").css('visibility', 'hidden');

    var newDocTitleEl = $element.find(".newDoc .title")[0];
    createToolTip(newDocTitleEl, prefData.title, "tooltip-title");
    onCoverImageOptionChange();

    $('#republishDocList > coral-select-item').each(function (index) {
      if ($(this)[0].value == "placeholder")
        $(this)[0].selected = true;
    });
  }

  $scope.initScope = InitScope;
  showRepublishWidgets(false);
  showPublishIAMUI(false);
  showInsertHTMLWarningUI(false);

  function SetCoverPath(coverPath) {
    $scope.$apply(function () {
      $scope.prefs.coverImagePath = coverPath;
    });
    onCoverImageOptionChange();
  }

  $scope.setCoverPath = SetCoverPath;

  $element.find(".pageOptions").change(function () {
    var pageRangeFormatOption = this.value;
    analyticsHelper.togglePageOptionsSelection();
    analyticsHelper.setPageRangeSelected(pageRangeFormatOption === "1");

    $('.pageOptions').each(function (index) {
      if ($(this)[0].value === pageRangeFormatOption)
        $(this)[0].checked = true;
      else
        $(this)[0].checked = false;
    });
    $scope.$apply(function () {
      $scope.prefs.pageRangeFormat = pageRangeFormatOption;
    });
  });

  $element.find("[name=radioMenuOptions]").change(function () {
    var menuOption = this.value;
    $scope.$apply(function () {
      $scope.prefs.isRepublishing = menuOption;
      if (menuOption === '1') {

        if (userPubs.fetchState === FETCH_STATE.COMPLETED) {
          if (userPubs.pubs.length === 0) {
            logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
              analyticsConstants.IDUsageTracking_kRepublishEvt_noDocFound);
            $("#chooseExistingDocLabel").hide();
            $("#noExistingDocumentWarning").show();
            $('#republishDocList').prop('disabled', true);
          } else if (analyticsHelper.getMatchState() === RepublishAnalyticsHelper.DocMatchState.kExactMatchFound) {
            logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
              analyticsConstants.IDUsageTracking_kRepublishEvt_exactMatch);
          } else if (analyticsHelper.getMatchState() === RepublishAnalyticsHelper.DocMatchState.kNotExactButOrigMatchFound) {
            logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
              analyticsConstants.IDUsageTracking_kRepublishEvt_origIdMatch);
          } else {
            logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
              analyticsConstants.IDUsageTracking_kRepublishEvt_noMatch);
          }
        }
        else if (userPubs.fetchState === FETCH_STATE.IN_PROGRSS) {
          logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
            analyticsConstants.IDUsageTracking_kRepublishEvt_statusInProgress);
        }
        else if (userPubs.fetchState === FETCH_STATE.ERROR) {
          logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_try,
            analyticsConstants.IDUsageTracking_kRepublishEvt_errorDocFetch);
        }

        pubNewDocGAParamas.measurementId = $("#MeasurementIdInput").val();
        pubNewDocGAParamas.enableCookieConsentBannerOption = $("#EnableCookieConsentBannerOption")[0].checked ? "1" : "0";
        pubNewDocGAParamas.cookieConsentBannerText = $("#CookieConsentBannerText").val();
        initGAAnalyticsControls();
        changePublishButtonStatus();

        if ($scope.prefs.isRepublishDocSelected != "1")
          $("#publishBtn").prop('disabled', true);
      } else {
        initGAAnalyticsControls();
        changePublishButtonStatus();
      }
    });
  });

  $element.find("#configOption").change(function () {
    var configOption = this.value;
    $scope.$apply(function () {
      $scope.prefs.enabledTab = configOption;
    });
    if (configOption == "Advanced") {
      $("#resolution").trigger("change");
    }
  });
  $element.find('#resolution').change(function (index) {
    var resolution = this.value;
    $scope.$apply(function () {
      $scope.prefs.imageResolution = resolution;
      if (resolution >= 100) {
        $element.find(".alert-icon").show();
      }
      else {
        $element.find(".alert-icon").hide();
      }
    });
  });

  $element.find(".spreadControl").change(function () {
    analyticsHelper.toggleSpreadControlSelection();
    var spreadControlOption = this.value;
    $('.spreadControl > button').each(function (index) {
      if ($(this)[0].value == spreadControlOption)
        $(this)[0].selected = true;
    });
    $scope.$apply(function () {
      $scope.prefs.spreadControl = spreadControlOption;
    });

  });
  $element.find("[name=thumbnailOptions]").change(function () {
    var thumbnailOptions = this.value;
    $scope.$apply(function () {
      $scope.prefs.coverImageOption = thumbnailOptions;
    });
    onCoverImageOptionChange();
  });

  $element.find(".pdfCheckBoxOption").change(function () {
    analyticsHelper.togglePdfSelectionChanged();
    var pdfCheckBoxOption = (this.checked == true) ? "1" : "0";
    var checked = this.checked;
    $(".pdfCheckBoxOption").each(function () {
      $(this)[0].checked = checked;
    });
    $scope.$apply(function () {
      $scope.prefs.pdfCheckBoxOption = pdfCheckBoxOption;
    });
  });

  $element.find(".enableSearchTextOption").change(function () {
    var enableSearchText = (this.checked == true) ? "1" : "0";
    var checked = this.checked;
    $(".enableSearchTextOption").each(function () {
      $(this)[0].checked = checked;
    });
    $scope.$apply(function () {
      $scope.prefs.enableSearchTextOption = enableSearchText;
    });
  });

  $element.find(".disableShareOption").change(function () {
    var disableShareOption = (this.checked == true) ? "1" : "0";
    var checked = this.checked;
    if (checked) {
      analyticsHelper.disableShareOptionOnce();
    }
    $(".disableShareOption").each(function () {
      $(this)[0].checked = checked;
    });
    $scope.$apply(function () {
      $scope.prefs.disableShareOption = disableShareOption;
    });
  });

  $element.find("#pdfPreset").change(function () {
    var selectedPdfPreset = this.value;
    if (selectedPdfPreset !== undefined) {
      $scope.$apply(function () {
        $scope.prefs.selectedPdfPreset = selectedPdfPreset;
      });
    }
  });
  $element.find("#format").change(function () {
    var selectedFormat = this.value;
    if (selectedFormat !== undefined) {
      $scope.$apply(function () {
        $scope.prefs.imageFormat = selectedFormat;
      });
    }
  });
  $element.find("#jpegQuality").change(function () {
    var selectedJpegQuality = this.value;
    if (selectedJpegQuality !== undefined) {
      $scope.$apply(function () {
        $scope.prefs.jpegImageQuality = selectedJpegQuality;
      });
    }
  });
  $element.find("#gifOptions").change(function () {
    var gifPaletteType = this.value;
    if (gifPaletteType !== undefined) {
      $scope.$apply(function () {
        $scope.prefs.gifPaletteType = gifPaletteType;
      });
    }
  });

  $element.find("[name=pageRange]").change(function () {
    $(".pageRangeInput").val($(this)[0].value).trigger('change');
    $(".pageRangeInput").focus();
  });

  $element.find(".pageRangeInput").blur(function () {
    var pageRangeValidationEvt = {};
    pageRangeValidationEvt.type = "Validate page range";
    pageRangeValidationEvt.text = this.value;
    sendEvent(pageRangeValidationEvt);
  });

  $element.find("#pageNum").change(function () {
    $scope.prefs.originalCoverPage = this.value;
    SetCoverPage(this.value);
  });

  $element.find(".newDoc .title").change(function () {
    var isValid = isValidTitle(this.value);
    if (!isValid) {
      showWarningMessage(resourceBundle['PublishAlertTitleMessage']);
      this.value = $scope.prefs.defaultTitle;
    }
    createToolTip(this, this.value, "tooltip-title");
  });

  $element.find(".newDoc .title").on('keyup', function (e) {
    changePublishButtonStatus();
  });

  $element.find("#docSettings .title").change(function () {
  	var isValid = isValidTitle(this.value);
    if (!isValid) {
      showWarningMessage(resourceBundle['PublishAlertTitleMessage']);
      this.value = $scope.prefs.defaultTitle;
    }
    createToolTip(this, this.value, "tooltip-repub-title");
  });

  $element.find("#pageNumInput").blur(function () {
    var pageNumberValidationEvt = {};
    pageNumberValidationEvt.type = "Validate page number";
    pageNumberValidationEvt.text = this.value;

    sendEvent(pageNumberValidationEvt);
    SetCoverPage(this.value);
  });

  function SetCoverPage(pageNumString) {
    if (pageNumString !== undefined) {
      $scope.$apply(function () {
        $scope.prefs.coverPage = pageNumString;
        $('#pageNum coral-select-item').each(function (idx) {
          var item = $('#pageNum coral-select-item')[idx];
          if (item.value == pageNumString) {
            $('#pageNum coral-select-item')[idx].selected = true;
          }
        });
      });
    }
    if ($scope.prefs.coverImageOption === "3") {
      //adding a delay of 500 ms before kicking up new image export, so as to avoid immediate image export for fast clicking on nudge button
      //this is done because currently background png export in ID is not supported
      window.clearTimeout(timer);
      timer = window.setTimeout(function () {
        onCoverImageOptionChange();
      }, 500);
    }
  }

  $element.find("#externalImagePath").change(function () {
    onCoverImageOptionChange();
    createToolTip(this, this.value, "tooltip-image-path");
  });

  $element.find("#MeasurementIdInput").on('input', function () {
    const measurementIdText = this.value;
    if (!isValidMeasurementId(measurementIdText)) {
      onInvalidMeasurementId();
    } else {
      onValidMeasurementId();
      $scope.$apply(function () {
        $scope.prefs.measurementId = measurementIdText;
      });
    }
    changePublishButtonStatus();
  });

  $element.find("#EnableCookieConsentBannerOption").change(function () {
    const enableConsentBannerOption = (this.checked === true) ? "1" : "0";
    let checked = this.checked;

    const measurementId = $("#MeasurementIdInput").val();

    if (!measurementId && (checked == false)) {
      $("#InvalidMeasurementId").css('visibility', 'hidden');
      $("#publishBtn").prop('disabled', false);
      $("#MeasurementIdInput")[0].style.borderColor = '';
    }

    if ((checked == true) && (!measurementId || !isValidMeasurementId(measurementId))) {
      $("#InvalidMeasurementId").css('visibility', 'visible');
      $("#InvalidMeasurementIdDesc").attr('data-locale', resourceBundle['EmptyMeasurementId']);
      $("#MeasurementIdInput").css('border-color', 'red');
      $("#MeasurementIdInput").css('box-shadow', 'none');
      $("#CookieConsentBannerText").prop('disabled', true);
      $("#CookieBannerTextAreaHeading").addClass('disabledLabel');
      $(this)[0].checked = false;
      checked = false;
      enableConsentBannerOption = "0";
    }

    if (checked == true) {
      $("#CookieConsentBannerText").prop('disabled', false);
      $("#CookieBannerTextAreaHeading").removeClass('disabledLabel');
    } else {
      $("#CookieConsentBannerText").prop('disabled', true);
      $("#CookieBannerTextAreaHeading").addClass('disabledLabel');
    }
    changePublishButtonStatus();
    $scope.$apply(function () {
      $scope.prefs.enableCookieConsentBannerOption = enableConsentBannerOption;
    });
  });

  function isExceedingCookieTextWordLimit(text) {
    let words = text.split(" ");
    if (words.length > MAX_COOKIE_TEXT_WORD_LENGTH) {
      return true;
    }
    return false;
  };

  $element.find("#CookieConsentBannerText").on('keypress', function (e) {
    if (isExceedingCookieTextWordLimit(this.value)) {
      if(e.key.match(/\s/)) {
        return false;
      }
    }
    return true;
  });

  $element.find("#CookieConsentBannerText").on('keyup', function (e) {
    changePublishButtonStatus();
  });

  $element.find("#CookieConsentBannerText").on('paste', function (e) {
    let text = this.value + e.originalEvent.clipboardData.getData('text');
    if (isExceedingCookieTextWordLimit(text)) {
      return false;
    }
    return true;
  });

  $element.find("#CookieConsentBannerText").change(function () {
    let cookieBannerText = this.value;
    $scope.$apply(function () {
      $scope.prefs.cookieConsentBannerText = cookieBannerText;
    });
  });

  $scope.republishDocumentSelected = function (selectedRepublishDoc) {
    $scope.prefs.republishUserPub = selectedRepublishDoc;

    $scope.prefs.republishAssetID = selectedRepublishDoc.asset_id;
    $scope.prefs.republishURL = selectedRepublishDoc.documentURL;
    var isValid = isValidTitle(selectedRepublishDoc.documentName);
    if (!isValid) {
      showWarningMessage(resourceBundle['PublishAlertTitleMessage']);
      $scope.prefs.repub.title = $scope.prefs.defaultTitle;
    }
    else {
      $scope.prefs.repub.title = selectedRepublishDoc.documentName;
    }
    $scope.prefs.repub.description = selectedRepublishDoc.description;
    fetchAndSetCoverImage(selectedRepublishDoc);
    $("#republishSelectedTitle").html(selectedRepublishDoc.documentName);
    var publishDate = new Date(selectedRepublishDoc.createdTime);
    $("#republishSelectedTimeStamp").html(getFormattedDateString(publishDate));
    $scope.prefs.isRepublishDocSelected = "1";
    showRepublishWidgets();
    $("#republishViewLink").unbind("click");
    $("#republishViewLink").click(function () {
      window.cep.util.openURLInDefaultBrowser(apiConfigData.idlmpHostName + selectedRepublishDoc.documentURL);
    });
    $("#publishBtn").prop('disabled', false);
    // if user is on analytics tab then publish button status needs to be cheked for analytics params
    changePublishButtonStatus();

    //tooltip
    var toolTipParentEl = $element.find("#docSettings .title")[0];
    createToolTip(toolTipParentEl, $scope.prefs.repub.title, "tooltip-repub-title");
  };

  $element.find("#republishDocList").change(function () {
    var selectedIndex = $(this).find('select')[0].selectedIndex;
    analyticsHelper.setSelectedIndex(selectedIndex, true);

    if (this.value !== "placeholder") {
      var selectedRepublishDoc = JSON.parse(this.value);
      $scope.republishDocumentSelected(selectedRepublishDoc);
      initGAAnalyticsControls();
    } else {
      $scope.prefs.isRepublishDocSelected = "0";
      $("#publishBtn").prop('disabled', true);
      showRepublishWidgets(false);
    }
    $scope.$apply();
  });

  $('#warningModal button').click(function () {
    $('#warningModal').hide();
  });

  var compositionOngoing = false;
  document.body.addEventListener('compositionstart', function (e) {
    compositionOngoing = true;
    return true;
  });
  document.body.addEventListener('compositionend', function (e) {
    compositionOngoing = false;
    return true;
  });

  document.body.addEventListener('keydown', function (e) {
    if (e.keyCode == 27 && !compositionOngoing) { // escape key while IME is inactive
      if ($('#republishConfirmModal').css('display') != 'none') {
        $('#republishCancelButton').trigger('click');
      }
      else if ($('#warningModal').css('display') != 'none') {
        $('#warningModal button').trigger('click');
      }
      else {
        csInterface.closeExtension();
      }
    }
    else if (e.keyCode == 13 && !compositionOngoing) { // Prevent enter key from publishing in case IME is active
      if ($(document.activeElement).is('.pageRangeInput')) {
        $('.pageRangeInput').trigger('blur');
        return;
      }
      else if ($(document.activeElement).is('#pageNumInput')) {
        $('#pageNumInput').trigger('blur');
        return;
      }
      else if (
        $(document.activeElement).is('#externalImagePath') ||
        $(document.activeElement).is('#externalImagePathButton')) {
        return;
      }
      else if ($(document.activeElement).is('textarea') == true) {
        return;
      }
      else if ($('#warningModal').css('display') != 'none') {
        $('#warningModal button').trigger('click');
      }
      else if ($('#republishConfirmModal').css('display') != 'none') {
        $('#republishOkButton').trigger('click');
      }
      else if ($("#publishBtn").prop('disabled') == false) {
        onPublish();
      }
    }
    else if (e.keyCode == 13 && compositionOngoing) {
      e.preventDefault(); // Prevent inadvertent newline addition in text areas. Bug with old chromium of CEP.
    }
  });
}
]);

function CheckAsyncForPublicShareFlagInCommunityPlatform() {
  $.ajax({
    url: apiConfigData.cpHostName + apiConfigData.cpPublicPublishPolicy,
    type: "GET",
    headers: {
      "X-Request-Id": "Indesign-last-mile-service",
      "Authorization": "Bearer " + apiConfigData.accessToken,
      "X-Api-Key": apiConfigData.cpApiKey,
      "Accept": "application/hal+json"
    },
    success: function (data, status, jqXHR) {
      if (!data.public_share) {
        showWarningMessageForPublicShare(false);
      }
      else {
        publicShareCheckCompleted = true;
        if (waitingToPublish) {
          onPublish();
        }
      }
    },
    error: function (jqXHR, status, errorThrown) {
      // highly unlikely, show a generic message and exit
      showWarningMessageForPublicShare(true); // For error
    }
  });
}

function fetchUserPublications(cursor) {
  var url = apiConfigData.idlmpHostName + apiConfigData.userPubsApiPath;
  if (cursor) {
    url += "?cursor=" + cursor;
  }
  else {
    userPubs.fetchBegin();
    userPubs.fetchState = FETCH_STATE.IN_PROGRSS;
  }
  var token = "Bearer " + apiConfigData.accessToken;
  var headers = {
    "Authorization": token
  };

  try {
    $.ajaxPrefilter(function (options, originalOptions, jqxhr) {
      var queryParams = {};
      queryParams.cursor = cursor ? cursor : "";
      jqxhr.queryParams = queryParams;
    });

    $.ajax({
      url: url,
      type: "GET",
      headers: headers,
      success: handleFetchPublicationsResponseSuccess,
      error: handleFetchPublicationsResponseError
    });
  }
  catch (err) {
    $('#debug_message').text(err);
    if (userPubs.retryAttempts < userPubs.MAX_ATTEMPTS) {
      setTimeout(function () {
        fetchUserPublications(cursor);
      }, userPubs.RETRY_INTERVAL);
      userPubs.retryAttempts++;
    }
    else {
      userPubs.fetchState = FETCH_STATE.ERROR;
      //TODO: show error
    }
  }
}

function populateDocumentsSelectList() {
  var republishDocList = $('#republishDocList').get(0);
  var i = 0;
  for (; (i + fRepublishDocDisplayCursor) < userPubs.pubs.length && i < 25; i++) {
    var pubJson = userPubs.pubs[i + fRepublishDocDisplayCursor];
    addValueToSelect(JSON.stringify(pubJson), republishDocList, pubJson.documentName);
    if (analyticsHelper.getMatchState() === RepublishAnalyticsHelper.DocMatchState.kExactMatchFound && (i + fRepublishDocDisplayCursor) === 0) {
      republishDocList.lastChild.selected = true;
      var scopeVar = $('body').scope();
      var selectedDoc = JSON.parse(republishDocList.value);
      scopeVar.republishDocumentSelected(selectedDoc);
      analyticsHelper.setSelectedIndex(1);	// matching doc will be at index 1
      scopeVar.$apply();
    }
  }
  fRepublishDocDisplayCursor = fRepublishDocDisplayCursor + i;
  if (fRepublishDocDisplayCursor < userPubs.pubs.length)
    setTimeout(populateDocumentsSelectList, 0);
}

function handleFetchPublicationsResponseSuccess(data, respText, jqxhr) {
  if (jqxhr.status === 200) {
    userPubs.retryAttempts = 0;
    [].forEach.call(data.items, function (val) {
      userPubs.pubs.push(val);
    });
    if (data.cursor !== "") {
      fetchUserPublications(data.cursor);
    }
    else {
      userPubs.fetchComplete();
      userPubs.fetchState = FETCH_STATE.COMPLETED;

      logHighbeamEvent(analyticsConstants.IDUsageTracking_kLastMilePublishing, analyticsConstants.IDUsageTracking_kRepublishSubcat_fetchTime, userPubs.getTimeToFetch().toString());

      if (userPubs.pubs.length > 0) {
        // Documents fetched at this point. Now sort document list according to rules.
        sortDocumentList();
        populateDocumentsSelectList();
      }
      else {
        $("#chooseExistingDocLabel").hide();
        $("#noExistingDocumentWarning").show();
        $('#republishDocList').prop('disabled', true);
      }
    }
  }
  else {
    var cursor = jqxhr.queryParams.cursor;
    if (userPubs.retryAttempts < userPubs.MAX_ATTEMPTS) {
      setTimeout(function () {
        fetchUserPublications(cursor)
      }, userPubs.RETRY_INTERVAL);
      userPubs.retryAttempts++;
    }
    else {
      userPubs.fetchState = FETCH_STATE.ERROR;
      //TODO: show error here
    }

    $('#debug_message').text(respText + "\nStatuscode: " + jqxhr.status);
  }
}

function handleFetchPublicationsResponseError(jqxhr, textStatus, err) {
  var cursor = jqxhr.queryParams.cursor;
  if (userPubs.retryAttempts < userPubs.MAX_ATTEMPTS) {
    setTimeout(function () {
      fetchUserPublications(cursor)
    }, userPubs.RETRY_INTERVAL);
    userPubs.retryAttempts++;
  }
  else {
    userPubs.fetchState = FETCH_STATE.ERROR;
    //TODO: show error here
  }
  $('#debug_message').text(textStatus + "\n" + err.toString());
}

function sortDocumentList() {
  var numExactMatching = 0,
    numOrigMatching = 0,
    numNoMatching = 0,
    sortedList = [],
    origDocIdList = [],
    genericList = [];

  userPubs.pubs.forEach(function (asset, idx, arr) {
    var machineTags = asset["machine_tags"];
    var documentId = "",
      origDocumentId = "";
    if (machineTags) {
      var ids = getDocumentIDsfromTags(machineTags);
      if (ids.documentId && ids.originalDocumentId) {
        documentId = ids.documentId;
        origDocumentId = ids.originalDocumentId;

        if (userPubs.documentId === documentId) {
          sortedList.push(asset);
          ++numExactMatching;
        }
        else if (userPubs.origDocumentId == origDocumentId) {
          origDocIdList.push(asset);
          ++numOrigMatching;
        }
        else {
          genericList.push(asset);
          ++numNoMatching;
        }
      }
      else {
        genericList.push(asset);
        ++numNoMatching;
      }
    }
    else {
      genericList.push(asset);
      ++numNoMatching;
    }
  });

  // Now add all to sorted list
  origDocIdList.forEach(function (val) {
    sortedList.push(val);
  });
  genericList.forEach(function (val) {
    sortedList.push(val);
  });

  userPubs.pubs = sortedList;

  analyticsHelper.setMatchingCounts({
    exactMatch: numExactMatching,
    origMatch: numOrigMatching,
    noMatch: numNoMatching
  });
}

function getDocumentIDsfromTags(machineTags) {
  var ids = {
    documentId: "",
    originalDocumentId: ""
  };
  var docIdPrefix = "document_id_",
    origDocIdPrefix = "orig_document_id_";
  if (machineTags instanceof Array && machineTags.length == 2) {
    machineTags.forEach(function (val) {
      if (val.indexOf(origDocIdPrefix) !== -1) {
        ids.originalDocumentId = val.substr(val.indexOf(origDocIdPrefix) + origDocIdPrefix.length);
      }
      else if (val.indexOf(docIdPrefix) !== -1) {
        ids.documentId = val.substr(val.indexOf(docIdPrefix) + docIdPrefix.length);
      }
    });
  }
  return ids;
}

// Fetching coverPreview with following settings:
// Format: png
// Dimensions: Height - 90px
function fetchAndSetCoverImage(asset) {
  var url = asset.coverPreview,
    formatStr = "{format}",
    sizeStr = "{size}",
    dimensionStr = "{dimension}",
    idxFormat = url.indexOf(formatStr),
    idxSize = url.indexOf(sizeStr),
    idxDimension = url.indexOf(dimensionStr);

  if (!url || idxFormat == -1 || idxDimension == -1 || idxSize == -1) {
    // cover Image not available. Show placeholder preview image
  }
  else {
    url = url.replace(formatStr, "png");
    url = url.replace(sizeStr, 90);
    url = url.replace(dimensionStr, "height");

    // Just assign the src to img tag's attribute
    $('#republishImagePlaceholder').attr('src', url);
  }
}
