function onLoaded() {
	var csInterface = new CSInterface();
	var appName = csInterface.hostEnvironment.appName;
	var language = csInterface.hostEnvironment.appUILocale;

	if (appName !== "FLPR") {
		loadJSX();
	}

	csInterface.initResourceBundle();

	updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);
	// Update the color of the panel when the theme color of the product changed.
	csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);
	csInterface.addEventListener("com.adobe.events.PublishHTML.indesign", publishHTMLEvtHandler);

	// Disable drop inside the panel
	window.ondragenter = function (event) {
		event.dataTransfer.dropEffect = 'none';
		event.stopPropagation();
		event.preventDefault();
	};
	window.ondragover = function (event) {
		event.dataTransfer.dropEffect = 'none';
		event.stopPropagation();
		event.preventDefault();
	};
	window.ondrop = function (event) {
		event.dataTransfer.dropEffect = 'none';
		event.stopPropagation();
		event.preventDefault();
	};

	sendExtenionLoadedEvent();
	$("#asset_url").prop("disabled", true);
}


/**
 * Update the theme with the AppSkinInfo retrieved from the host product.
 */
function updateThemeWithAppSkinInfo(appSkinInfo) {

	//Update the background color of the panel
	var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
	document.body.bgColor = toHex(panelBackgroundColor);

	var styleId = "ppstyle";

	var csInterface = new CSInterface();
	var appName = csInterface.hostEnvironment.appName;

	if (appName === "PHXS") {
		addRule(styleId, "button, select, input[type=button], input[type=submit]", "border-radius:3px;");
	}
	if (appName === "PHXS" || appName === "PPRO" || appName === "PRLD") {
		////////////////////////////////////////////////////////////////////////////////////////////////
		// NOTE: Below theme related code are only suitable for Photoshop.                            //
		// If you want to achieve same effect on other products please make your own changes here.    //
		////////////////////////////////////////////////////////////////////////////////////////////////


		var gradientBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 40) + " , " + toHex(panelBackgroundColor, 10) + ");";
		var gradientDisabledBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 15) + " , " + toHex(panelBackgroundColor, 5) + ");";
		var boxShadow = "-webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);";
		var boxActiveShadow = "-webkit-box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.6);";

		var isPanelThemeLight = panelBackgroundColor.red > 127;
		var fontColor, disabledFontColor;
		var borderColor;
		var inputBackgroundColor;
		var gradientHighlightBg;
		if (isPanelThemeLight) {
			fontColor = "#000000;";
			disabledFontColor = "color:" + toHex(panelBackgroundColor, -70) + ";";
			borderColor = "border-color: " + toHex(panelBackgroundColor, -90) + ";";
			inputBackgroundColor = toHex(panelBackgroundColor, 54) + ";";
			gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -40) + " , " + toHex(panelBackgroundColor, -50) + ");";
		}
		else {
			fontColor = "#ffffff;";
			disabledFontColor = "color:" + toHex(panelBackgroundColor, 100) + ";";
			borderColor = "border-color: " + toHex(panelBackgroundColor, -45) + ";";
			inputBackgroundColor = toHex(panelBackgroundColor, -20) + ";";
			gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -20) + " , " + toHex(panelBackgroundColor, -30) + ");";
		}


		//Update the default text style with pp values

		addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + fontColor + "; background-color:" + toHex(panelBackgroundColor) + ";");
		addRule(styleId, "button, select, input[type=text], input[type=button], input[type=submit]", borderColor);
		addRule(styleId, "button, select, input[type=button], input[type=submit]", gradientBg);
		addRule(styleId, "button, select, input[type=button], input[type=submit]", boxShadow);
		addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", gradientHighlightBg);
		addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", boxActiveShadow);
		addRule(styleId, "[disabled]", gradientDisabledBg);
		addRule(styleId, "[disabled]", disabledFontColor);
		addRule(styleId, "input[type=text]", "padding:1px 3px;");
		addRule(styleId, "input[type=text]", "background-color: " + inputBackgroundColor) + ";";
		addRule(styleId, "input[type=text]:focus", "background-color: #ffffff;");
		addRule(styleId, "input[type=text]:focus", "color: #000000;");

	}
	else {
		// For AI, ID and FL use old implementation
		addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + reverseColor(panelBackgroundColor) + "; background-color:" + toHex(panelBackgroundColor, 20));
		//addRule(styleId, "button", "border-color: " + toHex(panelBgColor, -50));
	}
}

function addRule(stylesheetId, selector, rule) {
	var stylesheet = document.getElementById(stylesheetId);

	if (stylesheet) {
		stylesheet = stylesheet.sheet;
		if (stylesheet.addRule) {
			stylesheet.addRule(selector, rule);
		}
		else if (stylesheet.insertRule) {
			stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
		}
	}
}


function reverseColor(color, delta) {
	return toHex({
		red: Math.abs(255 - color.red),
		green: Math.abs(255 - color.green),
		blue: Math.abs(255 - color.blue)
	}, delta);
}

/**
 * Convert the Color object to string in hexadecimal format;
 */
function toHex(color, delta) {
	function computeValue(value, delta) {
		var computedValue = !isNaN(delta) ? value + delta : value;
		if (computedValue < 0) {
			computedValue = 0;
		}
		else if (computedValue > 255) {
			computedValue = 255;
		}

		computedValue = computedValue.toString(16);
		return computedValue.length === 1 ? "0" + computedValue : computedValue;
	}

	var hex = "";
	if (color) {
		with (color) {
			hex = computeValue(red, delta) + computeValue(green, delta) + computeValue(blue, delta);
		}
		;
	}
	return "#" + hex;
}

function onAppThemeColorChanged(event) {
	// Should get a latest HostEnvironment object from application.
	var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
	// Gets the style information such as color info from the skinInfo,
	// and redraw all UI controls of your extension according to the style info.
	updateThemeWithAppSkinInfo(skinInfo);
}

/**
 * Load JSX file into the scripting context of the product. All the jsx files in
 * folder [ExtensionRoot]/jsx will be loaded.
 */
function loadJSX() {
	var csInterface = new CSInterface();
	var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
	csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
	new CSInterface().evalScript(script, callback);
}

function sendShareEvent(eventType) {
	var event = {};
	event.type = eventType;

	sendEvent(event);
}

function sendOpenURLEvent() {
	var openURLEvt = {};
	openURLEvt.type = "Open In Bowser";

	sendEvent(openURLEvt);
}

function sendUIInitCompleteEvent() {
	var uiInitCompleteEvt = {};
	uiInitCompleteEvt.type = "UI Init Complete";

	sendEvent(uiInitCompleteEvt);
}

function sendCloseEvent() {
	var closeEvt = {};
	closeEvt.type = "Upload Dialog Close";

	sendEvent(closeEvt);
}

function copyURL() {
	var copyUrlEvt = {};
	copyUrlEvt.type = "Copy url to clipboard";

	sendEvent(copyUrlEvt);
}

function openURL() {
	window.cep.util.openURLInDefaultBrowser($('#asset_url').val());
	sendOpenURLEvent();
}

function openSurvey() {
	window.cep.util.openURLInDefaultBrowser("http://www.adobe.com/go/publish_online_survey/");
}

function openWebDashboard() {
	var openDashboardEvt = {};
	openDashboardEvt.type = "Jump to PO Dashboard signed in";
	sendEvent(openDashboardEvt);
}

function shareFacebook() {
	var url = "https://www.facebook.com/sharer/sharer.php?u=";
	url += encodeURIComponent(this.asset_url);

	window.cep.util.openURLInDefaultBrowser(url);
	sendShareEvent("Upload Dialog Facebook Share");
}

function shareTwitter() {
	var title = $('#title_id').text();
	var assetUrl = $('#asset_url').val();
	var url = "http://twitter.com/share?";
	url += 'text=' + encodeURIComponent(title);
	url += '&url=' + encodeURIComponent(assetUrl);

	window.cep.util.openURLInDefaultBrowser(url);
	sendShareEvent("Upload Dialog Twitter Share");
}

function shareMail() {
	var assetUrl = $('#asset_url').val();
	var title = $('#title_id').text();
	var bodyText = $('#description_id').text();
	window.cep.util.openURLInDefaultBrowser("mailto:?subject=" + encodeURIComponent(title) +
			"&body=" + encodeURIComponent(bodyText ? bodyText : title) +
			"%0D%0A%0D%0A" + encodeURIComponent(assetUrl));
	sendShareEvent("Upload Dialog Email Share");
}

function cancelPublish() {
	var cancelPublishEvt = {};
	cancelPublishEvt.type = "Cancel Publish UI";

	sendEvent(cancelPublishEvt);
}

function closeExtension() {
	sendCloseEvent();
	var csInterface = new CSInterface();
	csInterface.closeExtension();
}

function setPercent(percent) {
	percent = Math.floor(percent);
	var csInterface = new CSInterface();
	var language = csInterface.hostEnvironment.appUILocale;
	if (language !== "tr_TR") {
		$('#percentLabel_id').text(percent + ' %');
	}
	else {
		$('#percentLabel_id').text('%' + percent);
	}

	$('#percentProgress_id').width(percent + '%');

	if (percent == 100) {
		$('#successUpload_id').removeClass("hidden");
		$('#share_id').removeClass("hidden");
		$('#progressUpload_id').addClass("hidden");
		$("#facebook_id").attr("disabled", false);
	}
	else {
		$('#successUpload_id').addClass("hidden");
		$('#share_id').addClass("hidden");
		$('#progressUpload_id').removeClass("hidden");
		$("#facebook_id").attr("disabled", true);
	}
}

function selectURLText() {
	var input = document.getElementById("asset_url");
	if (input.setSelectionRange)
		input.setSelectionRange(0, 9999);
}

function publishHTMLEvtHandler(event) {
	var evtInfo = event.data;
	if (evtInfo) {
		if (evtInfo.type === "Upload Progress") {
			setPercent(evtInfo.percent);
		}
		else if (evtInfo.type === "Published Doc URL") {
			$('#asset_url').val(evtInfo.docUrl);
			this.asset_url = evtInfo.docUrl;
			//selectURLText();
		}
		else if (evtInfo.type === "UI Initialization") {
			$('#error_unknown_id').addClass("hidden");
			$('#error_no_internet_id').addClass("hidden");
			$("#cover_id").attr("src", "file:///" + evtInfo.coverImagePath);
			setPercent(evtInfo.percent);
			$('#title_id').text(evtInfo.title);
			$('#description_id').text(evtInfo.description);
			$('#asset_url').val(evtInfo.docUrl);
			this.asset_url = evtInfo.docUrl;
			setTimeout(function () {
				sendUIInitCompleteEvent();
			}, 0);
		}
		else if (evtInfo.type === "Publish Failure") {
			if (evtInfo.reason === 'Network Error') {
				$('#error_no_internet_id').removeClass("hidden");
			}
			else if(evtInfo.reason.startsWith('Authentication Error')) {
				$('#error_authentication_id').removeClass("hidden");	
			}
			else {
				$('#error_unknown_id').removeClass("hidden");
			}
				var errCodeRegexMatch = evtInfo.reason.match(/ErrorCode:(\d+)/i);
				if (errCodeRegexMatch && errCodeRegexMatch.length >= 2)
				$(".error-Code").text("Error #" + errCodeRegexMatch[1]);
				$(".error-resourcePath").text("ID: " + evtInfo.resourcePathID);
			}
		}
	}

function sendExtenionLoadedEvent() {
	var extLoadedEvt = {};
	extLoadedEvt.type = "Extension Loaded";

	sendEvent(extLoadedEvt);
}

function sendEvent(data) {
	var csInterface = new CSInterface();
	var event = new CSEvent("com.adobe.events.HTMLPublishUI.html", "APPLICATION");
	event.extensionId = csInterface.getExtensionID();
	event.data = data;
	csInterface.dispatchEvent(event);
}
