//------------------------------------------------------------------------------------------------------
//--------------------------- Video Event Dispatchers -------------------------------------------------
//------------------------------------------------------------------------------------------------------

// This function dispatches event about change in videoPageLoadCheckbox.
function dispatchEventVideoPageLoadChekbox() {
    var isVideoPageLoadChecked = document.getElementById("videoPlayOnPageLoadCheckbox").checked;
    var eventData = isVideoPageLoadChecked ? "true" : "false";
    CSXSdispatchEvent("com.adobe.PageLoadMediaPanel", eventData);
}

// This function dispatches event about change in videoPageLoopCheckbox.
function dispatchEventVideoLoopCheckbox() {
    var isVideoLoopChecked = document.getElementById("videoLoopCheckBox").checked;
    var eventData = isVideoLoopChecked ? "true" : "false"; 
    CSXSdispatchEvent("com.adobe.LoopMediaPanel", eventData);
}

// This function dispatches event about change in videoPosterTypeSelect.
function dispatchEventVideoPosterType() {
    var selectedIndex = videoPosterDropDown.selectedIndex;
    var eventData = videoPosterDropDown.options[videoPosterDropDown.selectedIndex].text;

    if(eventData == window.resourceBundle.MP_FROMCURRENTFRAME){
        videoRefreshButton.style.display = "block";
        sendPosterImageToID(false);
    }
    else{
        videoRefreshButton.style.display = "none";
        if(eventData == window.resourceBundle.MP_CHOOSEFILEOPTION){
            CSXSdispatchEvent("com.adobe.PosterTypeMediaPanelChooseImage", eventData);
        }
        else{
            removeOptionFromDropdown(videoPosterDropDown, "fromFile"); 
            CSXSdispatchEvent("com.adobe.PosterTypeMediaPanel", selectedIndex.toString());
        }
    }
}

// This function dispatches events about adding a new navigation point.
function dispatchEventAddVideoNavigationPoint() {
    var currTime = getCurrTimeOfVideo();
    data = {};
    data.currentTime = currTime * 100;
    var eventData = JSON.stringify(data); 
    CSXSdispatchEvent("com.adobe.AddNavigationPoint", eventData);
}


// This function dispatches events about removing a new navigation point.
function dispatchEventRemoveVideoNavigationPoint(index) {
    data = {};
    data.index = parseInt(index);
    var eventData = JSON.stringify(data);
    CSXSdispatchEvent("com.adobe.RemoveNavigationPoint", eventData);
}

// This function dispatches events about removing a new navigation point.
function dispatchEventUpdateVideoNavigationPoints() {
    var eventData = JSON.stringify({})
    CSXSdispatchEvent("com.adobe.UpdateNavigationPoints", eventData);
}

// This function is called when video fails to load.
function dispatchEventVideoLoadingError(videoSrc){
    var eventData = JSON.stringify({})
    CSXSdispatchEvent("com.adobe.VideoLoadingError", videoSrc);
}   

//------------------------------------------------------------------------------------------------------
//--------------------------- Audio Event Dispatchers -------------------------------------------------
//------------------------------------------------------------------------------------------------------

// This function dispatches event about change in audioPlayOnPageLoadCheckbox.
function dispatchEventAudioPageLoadChekbox() {
    var isAudioPageLoadChecked = document.getElementById("audioPlayOnPageLoadCheckbox").checked;
    var eventData = isAudioPageLoadChecked ? "true" : "false";
    CSXSdispatchEvent("com.adobe.PageLoadAudio", eventData);
}

// This function dispatches event about change in audioStopOnPageTurnCheckbox.
function dispatchEventAudioStopOnPageTurnChekbox() {
    var isAudioStopOnPageTurnChecked = document.getElementById("audioStopOnPageTurnCheckbox").checked;
    var eventData = isAudioStopOnPageTurnChecked ? "true" : "false";
    CSXSdispatchEvent("com.adobe.StopOnTurnAudio", eventData);
}

// This function dispatches event about change in audioLoopCheckBox.
function dispatchEventLoopCheckbox() {
    var isAudioLoopChecked = document.getElementById("audioLoopCheckBox").checked;
    var eventData = isAudioLoopChecked ? "true" : "false" ;
    CSXSdispatchEvent("com.adobe.LoopCheckboxAudio", eventData);
}

// This function dispatches event about change in audioPosterTypeSelect.
function dispatchEventAudiPosterType() {
    var selectedIndex = audioPosterDropDown.selectedIndex;
    var eventData = audioPosterDropDown.options[audioPosterDropDown.selectedIndex].text;
    if (eventData == window.resourceBundle.MP_CHOOSEFILEOPTION) {
        CSXSdispatchEvent("com.adobe.PosterTypeMediaPanelChooseImage", eventData);
    } 
    else {
        removeOptionFromDropdown(audioPosterDropDown, "fromFile");
        window.audioDropDownSelectedIndex = selectedIndex;
        CSXSdispatchEvent("com.adobe.PosterTypeMediaPanel", selectedIndex.toString());
    }
}


// This function dispatches when PDFOptions button is clicked.
function dispatchEventPDFOptionSelected() {
    CSXSdispatchEvent("com.adobe.PDFOptionsMediaPanel", "");
}

// This function dispatches when EPUBInteractivity button is clicked.
function  dispatchEventEPUBInteractivitySelected() {
    CSXSdispatchEvent("com.adobe.EPUBInteractivityMediaPanel", "");
}

// This function dispatches when PlaceFromFile button is clicked.
function dispatchEventPlaceFromFileSelected () {
    CSXSdispatchEvent("com.adobe.PlaceFromFileMediaPanel", "");
}

function dispatchEventPlaceFromUrlSelected(){
    CSXSdispatchEvent("com.adobe.PlaceFromURLMediaPanel", "");
}

function dispatchEventChangeNameofNavigationPoint(name, index) {
    const data = { 
        index,
        name
    };

    const eventData = JSON.stringify(data);
    CSXSdispatchEvent("com.adobe.ChangeNameOfNavigationPoint", eventData);
}