function OnLoaded() {
    var csInterface = new CSInterface();
    // Disable all flyout menu items when initially Media Panel is loaded.
    updateAllFlyoutMenuItems(false, false);
    // Update the theme with the AppSkinInfo retrieved from the host product.
    updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);
    // Update the labels, options and other tooltips when locale change.
    updateAllStrings();
    // Attach all event listeners.
    attachAllCustomEventListeners();  

    //hide From File option in audio/video dropdown.
    removeOptionFromDropdown(audioPosterDropDown, "fromFile");
    removeOptionFromDropdown(videoPosterDropDown, "fromFile"); 

    // Dispatch ForceGetSelection event.
    var csEvent = new CSEvent("com.adobe.ForceGetSelection", "APPLICATION");
    csEvent.extensionId = csInterface.getExtensionID();
    csInterface.dispatchEvent(csEvent);    
}

// This function updates the flyout menu items depending on their flag.
function updateAllFlyoutMenuItems(shouldEnablePlaceVideo, shouldEnablePDFOptions){
    let csInterface = new CSInterface();
    let menuItems = [];
    menuItems.push({
        label: window.resourceBundle.MP_FLYOUTMENU1,
        enableMenu: shouldEnablePlaceVideo,
        onClick: function () {
        }
    });
    menuItems.push({
        label: window.resourceBundle.MP_FLYOUTMENU2,
        enableMenu: shouldEnablePDFOptions,
        onClick: function () {
        }
    });
    makeMenuItemMapping(menuItems);
    csInterface.setPanelFlyoutMenu(getTranslatedMenuXML(menuItems));
}

// Update the theme with the AppSkinInfo retrieved from the host product.
function updateThemeWithAppSkinInfo(appSkinInfo) {
    var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
    switch (panelBackgroundColor.red) {
        case lighterTheme:
            applyTheme(lighterTheme);
            break;
        case lightTheme:
            applyTheme(lightTheme);
            break;
        case darkTheme:
            applyTheme(darkTheme);
            break;
        case darkerTheme:
            applyTheme(darkerTheme);
            break;
    }
}

// ----------------------------TODO : see getListOfAllLabels-------------------------------------
// This function changes the labels, options and other tooltips when locales change.
function updateAllStrings() {
    document.getElementById("videoOptionsLabel").innerHTML = window.resourceBundle.MP_OPTIONS;
    document.getElementById("audioStopOnPageTurnLabel").innerHTML = window.resourceBundle.MP_STOPONPAGETURN;
    document.getElementById("videoLoopLabel").innerHTML = window.resourceBundle.MP_LOOP;
    document.getElementById("audioPosterTextLabel").innerHTML = window.resourceBundle.MP_POSTERLABEL;
    document.getElementById("videoPosterTextLabel").innerHTML = window.resourceBundle.MP_POSTERLABEL;
    document.getElementById("audioPlayOnPageLoadLabel").innerHTML = window.resourceBundle.MP_PLAYONPAGELOAD;
    document.getElementById("videoPlayOnPageLoadLabel").innerHTML = window.resourceBundle.MP_PLAYONPAGELOAD;
    document.getElementById("audioLoopLabel").innerHTML = window.resourceBundle.MP_LOOP;
    document.getElementById("audioNoneOption").innerHTML = window.resourceBundle.MP_NONEOPTION;
    document.getElementById("audioStandardOption").innerHTML = window.resourceBundle.MP_STANDARDOPTION;
    document.getElementById("audioChooseImageOption").innerHTML = window.resourceBundle.MP_CHOOSEFILEOPTION;
    document.getElementById("videoNoneOption").innerHTML = window.resourceBundle.MP_NONEOPTION;
    document.getElementById("videoStandardOption").innerHTML = window.resourceBundle.MP_STANDARDOPTION;
    document.getElementById("videoChooseImageOption").innerHTML = window.resourceBundle.MP_CHOOSEFILEOPTION;
    document.getElementById("videoCurrentFrameOption").innerHTML = window.resourceBundle.MP_FROMCURRENTFRAME;
    document.getElementById("audioOptionsLabel").innerHTML = window.resourceBundle.MP_OPTIONS;

    document.getElementById("videoFromFileOption").innerHTML = window.resourceBundle.MP_FROMFILE;
    document.getElementById("audioFromFileOption").innerHTML = window.resourceBundle.MP_FROMFILE;


    document.getElementById("videoControllerTextLabel").innerHTML = window.resourceBundle.MP_FROMFILE ;
    document.getElementById("controllerRolloverLabel").innerHTML = window.resourceBundle.MP_FROMFILE ;
    document.getElementById("controllerNone").innerHTML = window.resourceBundle.MP_NONEOPTION ;
    document.getElementById("controllerOption1").innerHTML = "Option 1" ;
    document.getElementById("controllerOption2").innerHTML = "Option 2" ;
    document.getElementById("controllerOption3").innerHTML = "Option 3" ;

    document.getElementById("navigationPointsLabel").innerHTML = window.resourceBundle.MP_NAVIGATIONPOINTSLABEL;
}

function attachAllCustomEventListeners(){
    var csInterface = new CSInterface();
    //add all videoPanel control event listeners
    addVideoControlEventListeners();
    //add all audioPanel control event listeners
    addAudioControlEventListeners();

    // attach event listeners to show tooltips
    attachToolTipEventListeners();

    //disable drop inside the panel
    document.addEventListener("dragover", function (event) { event.preventDefault();});
    document.addEventListener("drop", function (event) { event.preventDefault();});
    // adding other event listeners 
    csInterface.addEventListener("EmptyGraphicFrameUpdate", emptyGraphicFrameUpdateEventListener);
    csInterface.addEventListener("DocWithNoOrMultipleSelection", docWithNoOrMultipleSelectionEventListener);
    csInterface.addEventListener("NoDocUpdate", noDocUpdateEventListener);
    csInterface.addEventListener("VideoUpdate", videoUpdateEventListener);
    csInterface.addEventListener("AudioUpdate", audioUpdateEventListener);
    csInterface.addEventListener("afterSelectionChanged", afterSelectionChangedEventListener);
    csInterface.addEventListener("NavigationPointUpdate", mediaPanelNavigationPointTableEventListener);
    csInterface.addEventListener("GetPosterUpdate", getPosterUpdateEventListener);
    csInterface.addEventListener("PosterFromFile", posterFromFileEventListener);
    csInterface.addEventListener("MediaPanelClose", mediaPanelCloseEventListener);
    csInterface.addEventListener('com.adobe.csxs.events.flyoutMenuClicked', onFlyoutMenuItemClickedEventListener);
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChangedEventListener);
}

function addVideoControlEventListeners(){
    attachVideoPlayButtonEventListener();
    attachVideoMuteButtonEvenListener();
    attachVideoSeekBarControllerUpdateEventListener();
    attachVideoTimeUpdateEventListener();
    attachVideoEndEventListener();
    attachTempVideoMetadataLoadedListener();
}

function addAudioControlEventListeners(){
    attachAudioPlayButtonEventListener();
    attachAudioMuteButtonEvenListener();
    attachAudioSeekBarControllerUpdateEventListener();
    attachAudioTimeUpdateEventListener();
    attachAudioEndEventListener();
}

function showVideoPanelContainer() {
    if (getStyle("videoPanelContainer", "display") === "none") {
        document.getElementById("audioPanelContainer").style.display = "none";
        document.getElementById("videoPanelContainer").style.display = "block";
    }
}

function showAudioPanelContainer() {
    if (getStyle("audioPanelContainer", "display") === "none") {
        document.getElementById("audioPanelContainer").style.display = "block";
        document.getElementById("videoPanelContainer").style.display = "none";
    }
}
// Get the color of the disabled text color depending on the theme applied.
function getDisabledTextColor() {
    switch (window.appliedTheme) {
        case lighterTheme:
            return window.lighterThemeDisabledTextColor;
        case lightTheme:
            return window.lightThemeDisabledTextColor;
        case darkTheme:
            return window.darkThemeDisabledTextColor;
        case darkerTheme:
            return window.darkerThemeDisabledTextColor;
    }
}

// Get the color of the enabled text color depending on the theme applied.
function getEnabledTextColor() {
    switch (window.appliedTheme) {
        case lighterTheme:
            return window.lighterThemeEnabledTextColor;
        case lightTheme:
            return window.lightThemeEnabledTextColor;
        case darkTheme:
            return window.darkThemeEnabledTextColor;
        case darkerTheme:
            return window.darkerThemeEnabledTextColor;
    }
}

// Get the color of the option depending on the theme applied.
function getDisabledOptionColor() {
    switch (window.appliedTheme) {
        case lighterTheme:
            return window.lighterThemeOptionDisabled;
        case lightTheme:
            return window.lightThemeOptionDisabled;
        case darkTheme:
            return window.darkThemeOptionDisabled;
        case darkerTheme:
            return window.darkerThemeOptionDisabled;
    }
}

// Checks if a text label is disabled.
function isDisabledTextLabel(labelCol) {
    var disabledTextColorArray = [window.lighterThemeDisabledTextColor, window.lightThemeDisabledTextColor,  window.darkThemeDisabledTextColor, window.darkerThemeDisabledTextColor];
    return disabledTextColorArray.includes(labelCol);
}

// This function changes the labels of the text dependending on the  theme.
function changeLabelsAccordingToTheme() {
    var labelsArray = getListOfAllLabels();
    for(var index = 0; index < labelsArray.length; index++){
        var label = labelsArray[index];
        document.getElementById(label).style.color = isDisabledTextLabel(getStyle(label,"color")) ? getDisabledTextColor() : getEnabledTextColor();
    }
}

// Get the enabled color of the option depending on theme applied.
function getEnabledOptionColor() {
    return 'rgb(' + window.appliedTheme + ',' + window.appliedTheme + ',' + window.appliedTheme + ')';
}

// Get the color of option depending on theme and whether it is disabled or enabled
function getOptionColor() {
    return window.isMediaPanelDisabled ? getDisabledOptionColor() : getEnabledOptionColor();
}