// Central function to dispatch events to ID. 
function CSXSdispatchEvent(eventName, eventData) {
    var csInterface = new CSInterface();
    var event = new CSEvent(eventName, "APPLICATION");
    event.data = eventData;
    event.extensionId = csInterface.getExtensionID();
    csInterface.dispatchEvent(event);
}

// Get the specific style of a HTML element. 
// Note: Do not use document.getElementById(id).style to get style of an element in case if you have used external CSS.
function getStyle(id, name)
{
    let element = document.getElementById(id);
    return window.getComputedStyle ? window.getComputedStyle(element, null).getPropertyValue(name) : null;
}


// This function adds an option to a dropdown.
function addOptionToDropdown( dropdown, optionValue, mediaType) {
    if(optionValue == "fromFile"){
        if(dropdown.id == "videoPosterTypeSelect"){
            document.getElementById("videoFromFileOption").style.display = "block";
        }
        else if(dropdown.id == "audioPosterTypeSelect"){
            document.getElementById("audioFromFileOption").style.display = "block";   
        }
    }
    else if(optionValue == "currentFrame"){
        document.getElementById("videoCurrentFrameOption").style.display = "block";
    }
}

// This function removes an option from dropdown.
function removeOptionFromDropdown(dropdown, optionValue){
    if(optionValue == "fromFile"){
        if(dropdown.id == "videoPosterTypeSelect"){
            document.getElementById("videoFromFileOption").style.display = "none";
        }
        else if(dropdown.id == "audioPosterTypeSelect"){
            document.getElementById("audioFromFileOption").style.display = "none";   
        }
    }
    else if(optionValue == "currentFrame"){
        document.getElementById("videoCurrentFrameOption").style.display = "none";
    }
}

//This function tells whether a file extension is unsupported
function isUnsupportedExtension(mediaFileName){
    // Following extensions are not supported by Adobe Flash.
    var re = /(?:\.([^.]+))?$/;
    var ext = (re.exec(mediaFileName)[1]).toUpperCase().toUpperCase();
    var inValidExtensions = [".AIF", ".AIFF", ".AU", ".AVI", ".WAV", ".MPEG", ".MPG"];
    if(!mediaFileName || (typeof ext !== "undefined" && (inValidExtensions.indexOf(ext) != -1 )) )
        return true;
    else
        return false;
}

//This function asynchronously updates duration label
function asyncUpdateDurationLabel(panel, currentDurationLabel, totalDurationLabel) {
    window.setInterval(function (t) {
        if (panel.readyState > 0) {
            var whereYouAt = panel.currentTime;
            var minutes = Math.floor(whereYouAt / 60);
            var seconds = Math.floor(whereYouAt - minutes * 60)
            var x = minutes < 10 ? "0" + minutes : minutes;
            var y = seconds < 10 ? "0" + seconds : seconds;
            var totalTime = panel.duration;
            var minutes1 = Math.floor(totalTime / 60);
            var seconds1 = Math.floor(totalTime - minutes1 * 60)
            var x1 = minutes1 < 10 ? "0" + minutes1 : minutes1;
            var y1 = seconds1 < 10 ? "0" + seconds1 : seconds1;
            var currentTime = x + ":" + y ;
            var fullTime = (x1 + ":" + y1);
            currentDurationLabel.innerHTML = currentTime;
            totalDurationLabel.innerHTML = fullTime;
        }
    }, 500);
}

//This function returns poster type value depending on poster type.
function getPosterTypeValue(postertype){
    var mapVideo = new Map([
            ["None", "none"],
            ["Standard", "standard"],
            ["FromMedia", "currentFrame"],
            ["ProxyImage", "chooseImage"]
        ]);
    return mapVideo.get(postertype);
}



function getTranslatedMenuXML(menuItems, isSubMenu) {
    let strMenuItems = '';
    menuItems.forEach((menuItem) => {
        if (menuItem.divider) {
            strMenuItems += '<MenuItem Label="---"/>';
        } else {
            strMenuItems += constructMenuItem({
                Id: menuItem.menuId,
                Label: removeEscapeValues(menuItem.label),
                Checkable: true,
                Checked: menuItem.checked,
                Enabled: menuItem.hasOwnProperty('enableMenu') ? menuItem.enableMenu : true
            }, menuItem.menuItems);
        }
    });
    if (!isSubMenu) {
        strMenuItems = '<Menu>' + strMenuItems + '</Menu>';
    }
    return strMenuItems;
}

// This function makes menu item mapping.
// <menu>
//   <MenuItem Id="VideoFromURL" Label="Video from URL..." Enabled="false"/>
//   <MenuItem Id= "PDFOptions" Label="PDF Options" Enabled="false"/>
//</menu>
function makeMenuItemMapping(menuItems, mapping, prefix) {
    mapping = mapping || {};
    prefix = prefix || 'MENU';
    menuItems.forEach(function (menuItem, index) {
        let id = prefix + '_' + index;
        menuItem.menuId = id;
        mapping[id] = menuItem;

        if (menuItem.menuItems) {
            makeMenuItemMapping(menuItem.menuItems, mapping, id);
        }
    });
    return mapping;
}

// This function constructs menu items. This is required for flyout menu.
function constructMenuItem(attributes, subMenuItems) {
    // Construct the attributes
    let attributesStr = '';
    Object.keys(attributes).forEach(function (key) {
        if (attributes[key] !== undefined) {
            attributesStr += key + '="' + attributes[key] + '" ';
        }
    });
    // Construct the subMenu
    let subMenuStr = '';
    if (subMenuItems) {
        subMenuStr = getTranslatedMenuXML(subMenuItems, true);
    }
    return '<MenuItem ' + attributesStr + '>' + subMenuStr + '</MenuItem>';
}

// This function removes the escape values. This is required for flyout menu.
function removeEscapeValues(value) {
    value = value.replace(new RegExp('&', 'g'), '&amp;')
        .replace(new RegExp('"', 'g'), '&quot;')
        .replace(new RegExp("'", 'g'), '&apos;')
        .replace(new RegExp('<', 'g'), '&lt;')
        .replace(new RegExp('>', 'g'), '&gt;');
    return value;
}

// This function sends poster image as base64 encoded string to ID.
function sendPosterImageToID(placeMedia, videoObject, attribs) {
    var isPlaying = false;
    if (!videoObject) {
        videoObject = document.getElementById("videoPanel");
        if (videoObject.isPlaying === true) {
            isPlaying = true;
        }
    }
    
    var curtime = videoObject.currentTime;
    if (curtime < 0.01) {
        curtime = 0.01; // setting curtime to a small value to get the first frame.
    }
    
    if(videoObject.videoHeight!=0 && videoObject.videoWidth!=0)
    {
        var canvas = document.createElement('canvas');
        canvas.height = videoObject.videoHeight;
        canvas.width = videoObject.videoWidth;
        var ctx = canvas.getContext('2d');
        ctx.drawImage(videoObject, 0, 0, canvas.width, canvas.height);
        var img = new Image();
        img.src = canvas.toDataURL();
        var item_image = img.src.replace(/^data:image\/(png|jpg);base64,/, "");
        videoObject.currentTime = curtime;
        if (isPlaying) {
            videoObject.play();
        }
        var data = {};
        data.imageData = item_image;
        if (attribs) {
            data.documentID = attribs.documentID;
            data.mediaID = attribs.mediaID;
        }

        var dataToSend = JSON.stringify(data);
        if(placeMedia) {
            CSXSdispatchEvent("com.adobe.PlaceMediaPosterImage", dataToSend);
        } else {
            CSXSdispatchEvent("com.adobe.GetCurrentFrameImage", dataToSend);
        }
    }
}

function getToolTipText(toolTipId) {
    switch (toolTipId) {
        case 'videoEpubInteractivityToolTip':
        case 'audioEpubInteractivityToolTip':
            return window.resourceBundle.MP_EPUBTIP;
        case 'videoPlaceFromFileToolTip':
        case 'audioPlaceFromFileToolTip':
            return window.resourceBundle.MP_VIDEOAUDIOTIP;
        case 'videoPdfOptionsToolTip':
        case 'audioPdfOptionsToolTip':
            return window.resourceBundle.MP_INTEXPORTTIP;
        case 'videoPlaceFromUrlToolTip':  
            return window.resourceBundle.MP_PLACEFROMURLTIP;
        case 'videoRefreshButtonToolTip':
            return window.resourceBundle.MP_REFRESH;
        case 'playOnLoopToolTip':
            return window.resourceBundle.MP_LOOP;
        case 'playOnPageLoadTip':
            return window.resourceBundle.MP_PLAYONPAGELOAD;
        case 'audioStopOnPageTurnToolTip':
            return window.resourceBundle.MP_STOPONPAGETURN;
        case 'alertToolTip':
            return window.resourceBundle.MP_ALERTTOOLTIP;
        default:
            return "";
    }
}


// This function shows the tooltip.
function showToolTip(refNode, toolTipId) {
    const toolTip = document.getElementById("toolTip");
    adjustToolTipText(toolTipId);
    positionToolTip(refNode);
}

function adjustToolTipText(toolTipId) {
    const toolTip =  document.getElementById("toolTip");
    const toolTipStr = getToolTipText(toolTipId);

    while (toolTip.firstChild) {
        toolTip.removeChild(toolTip.firstChild);
    }

    toolTip.textContent = toolTipStr;
    const toolTipWidth = toolTip.offsetWidth;

    if(toolTipWidth > window.innerWidth) {
        const words = toolTipStr.split(" ");
        
        const dummyDiv = document.createElement("div");
        dummyDiv.classList.add("commonToolTipStyle");
        document.body.appendChild(dummyDiv);
        dummyDiv.textContent = words[0] + " ";

        let width = 0, idx = 0, firstLineStr = "";
        toolTip.removeChild(toolTip.firstChild);

        while(idx < words.length && width + dummyDiv.offsetWidth < window.innerWidth) {
            firstLineStr += words[idx++] + " ";
            toolTip.textContent = firstLineStr.slice(0, -1);
            width = toolTip.offsetWidth;
            dummyDiv.textContent = words[idx] + " ";
        }

        if(idx === 0) {
            // this means that the first word covers the entire width of the panel. As of now put everything on the first line. Ideal fix would be 
            // to get the string changed.
            toolTip.textContent = toolTipStr;
        }
        else if(idx > 0 && idx < words.length) {
            const lineBreak = document.createElement("br");
            toolTip.appendChild(lineBreak);
            let remainingStr = words.slice(idx).join(" ");
            const remainingTextNode = document.createTextNode(remainingStr);
            toolTip.appendChild(remainingTextNode);
        } 

        dummyDiv.remove();
    }
}

// This function hides the tooltip.
function hideToolTip() {
    const toolTip = document.getElementById("toolTip");
    toolTip.style.visibility = "hidden";
}

function positionToolTip(refNode) {
    const toolTip =  document.getElementById("toolTip");
    const boundingRect = refNode.getBoundingClientRect();

    const toolTipHeight = toolTip.clientHeight;

    //Try to show the tooltip above the reference element. If that is not possible, show it below the element.
    if(boundingRect.top - toolTipHeight >= 0) {
        toolTip.style.top = Math.floor(boundingRect.top - toolTipHeight) + "px";
    }
    else {
        toolTip.style.top = Math.floor(boundingRect.bottom) + "px";
    }

    // Now try to position the tooltip along the horizontal. First we try to center around it around the reference element(refNode).
    let tipLeftOffset = boundingRect.left + Math.floor((boundingRect.width - toolTip.offsetWidth) / 2);

    if (tipLeftOffset < 2) {
        tipLeftOffset = 2;
    }

    if(tipLeftOffset + toolTip.offsetWidth > window.innerWidth) {
        tipLeftOffset = window.innerWidth - toolTip.offsetWidth - 2;
        tipLeftOffset = Math.max(tipLeftOffset, 0);
    }

    toolTip.style.left = Math.floor(tipLeftOffset) + "px";
    toolTip.style.visibility = "visible";
}

function getStyleSheetFileAccordingToTheme(themeColorValue) {
    switch (themeColorValue) {
        case lighterTheme:
            return "lighterTheme.css";
        case lightTheme:
            return "lightTheme.css";
        case darkTheme:
            return "darkTheme.css";
        case darkerTheme:
            return "darkerTheme.css";        
        default:
            return "darkTheme.css";
    }
}

// This function applies the corresponding theme.
function applyTheme(themeColorValue) {
    // changing css file.
    window.appliedTheme = themeColorValue;
    var styleSheet = document.getElementById("theme");
    styleSheet.href = getStyleSheetFileAccordingToTheme(themeColorValue);
    var colStr = 'rgb(' + themeColorValue + ',' + themeColorValue + ',' + themeColorValue + ')';
    document.body.style.backgroundColor = colStr;
    changeLabelsAccordingToTheme();
}

// Get a list of all labels present in Media Panel. Add newly added label entries here.
function getListOfAllLabels() {
    return [
        "videoCurrentDurationLabel",
        "videoTotalDurationLabel",
        "videoOptionsLabel",
        "videoPlayOnPageLoadLabel",
        "videoLoopLabel",
        "videoPosterTextLabel",
        "videoPosterTypeSelect",
        "videoControllerTextLabel",
        "videoControllerSelect",
        "controllerRolloverLabel",
        "navigationPointsLabel",
        "audioCurrentDurationLabel",
        "audioTotalDurationLabel",
        "audioOptionsLabel",
        "audioPlayOnPageLoadLabel",
        "audioStopOnPageTurnLabel",
        "audioLoopLabel",
        "audioPosterTextLabel",
        "audioPosterTypeSelect",
    ];
}

function getNavigationPointTime(){
    var whereYouAt = videoPanel.currentTime;
    var minutes = Math.floor(whereYouAt / 60);
    var seconds = Math.floor(whereYouAt - minutes * 60)
    var x = minutes < 10 ? "0" + minutes : minutes;
    var y = seconds < 10 ? "0" + seconds : seconds;
    var currentTime = "00:" + x + ":" + y ;
    return currentTime;
}

// This function sends time in video base64 encoded string to ID for Navigation point creation.
function getCurrTimeOfVideo(videoObject) {
    if (!videoObject) {
        videoObject = document.getElementById("videoPanel");
    }
    
    var curtime = videoObject.currentTime;
    if (curtime < 0.01) {
        curtime = 0.01; // setting curtime to a small value to get the first frame.
    }
    
    return curtime;
}

function getNavigationPointTimefromGivenTime(time) {
    var whereYouAt = time / 100;
    var minutes = Math.floor(whereYouAt / 60);
    var seconds = Math.floor(whereYouAt - minutes * 60)
    var x = minutes < 10 ? "0" + minutes : minutes;
    var y = seconds < 10 ? "0" + seconds : seconds;
    var currentTime = "00:" + x + ":" + y ;
    return currentTime;
}